% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datamanag.R
\name{hist_null}
\alias{hist_null}
\title{Create Historical MPMs Assuming No Influence of Individual History}
\usage{
hist_null(mpm, format = 1, err_check = FALSE)
}
\arguments{
\item{mpm}{An ahistorical MPM of class \code{lefkoMat}.}

\item{format}{An integer stipulating whether historical matrices should be
produced in Ehrlen format (\code{1}) or deVries format (\code{2}).}

\item{err_check}{A logical value indicating whether to output the main index
used to sort elements in the matrices.}
}
\value{
An object of class \code{lefkoMat}, with the same list structure as
the input object, but with \code{A}, \code{U}, and \code{F} elements replaced
with lists of historically-structured matrices, and with element
\code{hstages} changed from \code{NA} to an index of stage pairs
corresponding to the rows and columns of the new matrices. If
\code{err_check = TRUE}, then a data frame showing the values used to
determine element index values is also exported.
}
\description{
Function \code{hist_null()} uses ahistorical MPMs to create the equivalent
MPMs in the structure of historical MPMs. These MPMs have the same dimensions
and stage structure of hMPMs but assume no influence of individual history,
and so can be compared to actual hMPMs.
}
\examples{
sizevector <- c(1, 1, 2, 3)
stagevector <- c("Sdl", "Veg", "SmFlo", "LFlo")
repvector <- c(0, 0, 1, 1)
obsvector <- c(1, 1, 1, 1)
matvector <- c(0, 1, 1, 1)
immvector <- c(1, 0, 0, 0)
propvector <- c(0, 0, 0, 0)
indataset <- c(1, 1, 1, 1)
binvec <- c(0.5, 0.5, 0.5, 0.5)

anthframe <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

# POPN C 2003-2004
XC3 <- matrix(c(0, 0, 1.74, 1.74,
0.208333333, 0, 0, 0.057142857,
0.041666667, 0.076923077, 0, 0,
0.083333333, 0.076923077, 0.066666667, 0.028571429), 4, 4, byrow = TRUE)

# 2004-2005
XC4 <- matrix(c(0, 0, 0.3, 0.6,
0.32183908, 0.142857143, 0, 0,
0.16091954, 0.285714286, 0, 0,
0.252873563, 0.285714286, 0.5, 0.6), 4, 4, byrow = TRUE)

mats_list <- list(XC3, XC4)
yr_ord <- c(1, 2)
pch_ord <- c(1, 1)

anth_lefkoMat <- create_lM(mats_list, anthframe, hstages = NA, historical = FALSE,
  poporder = 1, patchorder = pch_ord, yearorder = yr_ord)
  
anth_lefkoMat

nullmodel1 <- hist_null(anth_lefkoMat, 1) # Ehrlen format
nullmodel2 <- hist_null(anth_lefkoMat, 2) # deVries format

}
