% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{f_projection3}
\alias{f_projection3}
\title{Project Function-based Matrix Projection Model}
\usage{
f_projection3(
  data,
  format,
  prebreeding = TRUE,
  start_age = NA_integer_,
  last_age = NA_integer_,
  fecage_min = NA_integer_,
  fecage_max = NA_integer_,
  cont = TRUE,
  stochastic = FALSE,
  standardize = FALSE,
  growthonly = TRUE,
  repvalue = FALSE,
  integeronly = FALSE,
  substoch = 0L,
  ipm_method = "CDF",
  nreps = 1L,
  times = 10000L,
  repmod = 1,
  exp_tol = 700,
  theta_tol = 1e+08,
  random_inda = FALSE,
  random_indb = FALSE,
  random_indc = FALSE,
  err_check = FALSE,
  quiet = FALSE,
  stageframe = NULL,
  supplement = NULL,
  repmatrix = NULL,
  overwrite = NULL,
  modelsuite = NULL,
  paramnames = NULL,
  year = NULL,
  patch = NULL,
  sp_density = NULL,
  ind_terms = NULL,
  dev_terms = NULL,
  surv_model = NULL,
  obs_model = NULL,
  size_model = NULL,
  sizeb_model = NULL,
  sizec_model = NULL,
  repst_model = NULL,
  fec_model = NULL,
  jsurv_model = NULL,
  jobs_model = NULL,
  jsize_model = NULL,
  jsizeb_model = NULL,
  jsizec_model = NULL,
  jrepst_model = NULL,
  jmatst_model = NULL,
  start_vec = NULL,
  start_frame = NULL,
  tweights = NULL,
  density = NULL,
  density_vr = NULL
)
}
\arguments{
\item{data}{The historical vertical demographic data frame used to estimate
vital rates (class \code{hfvdata}), which is required to initialize times and
patches properly. Variable names should correspond to the naming conventions
in \code{\link{verticalize3}()} and \code{\link{historicalize3}()}.}

\item{format}{An integer indicating the kind of function-based MPM to create.
Possible choices include: \code{1}, Ehrlen-format historical MPM; \code{2},
deVries-format historical MPM; \code{3}, ahistorical MPM; \code{4},
age-by-stage MPM; and \code{5}, Leslie (age-based) MPM.}

\item{prebreeding}{A logical value indicating whether the life history model
is a pre-breeding model. Only used in Leslie and age-by-stage MPMs. Defaults
to \code{TRUE}.}

\item{start_age}{The age from which to start the matrix. Defaults to
\code{NA}, in which case age \code{1} is used if \code{prebreeding = TRUE},
and age \code{0} is used if \code{prebreeding = FALSE}.}

\item{last_age}{The final age to use in the matrix. Defaults to \code{NA}, in
which case the highest age in the dataset is used.}

\item{fecage_min}{The minimum age at which reproduction is possible. Defaults
to \code{NA}, which is interpreted to mean that fecundity should be assessed
starting in the minimum age observed in the dataset.}

\item{fecage_max}{The maximum age at which reproduction is possible. Defaults
to \code{NA}, which is interpreted to mean that fecundity should be assessed
until the final observed age.}

\item{cont}{A logical value designating whether to allow continued survival
of individuals past the final age noted in the stageframe, using the 
demographic characteristics of the final age. Defaults to \code{TRUE}.}

\item{stochastic}{A logical value denoting whether to conduct a stochastic
projection or a deterministic / cyclical projection.}

\item{standardize}{A logical value denoting whether to re-standardize the
population size to \code{1.0} at each occasion. Used in density-independent
simulations in which it is more important to know the general trend in
population growth than the explicit growth rate. Defaults to \code{FALSE}.}

\item{growthonly}{A logical value indicating whether to produce only the
projected population size at each occasion (\code{TRUE}), or also to produce
vectors showing the stage distribution at each occasion (\code{FALSE}).
Defaults to \code{TRUE}.}

\item{repvalue}{A logical value indicating whether to calculate reproductive
value vectors at each time step. Can only be set to \code{TRUE} if 
\code{growthonly = FALSE}. Setting to \code{TRUE} may dramatically increase
the duration of calculations. Defaults to \code{FALSE}.}

\item{integeronly}{A logical value indicating whether to round the number of
individuals projected in each stage at each occasion to the nearest
integer. Defaults to \code{FALSE}.}

\item{substoch}{An integer value indicating whether to force survival-
transition matrices to be substochastic in density dependent and density
independent simulations. Defaults to \code{0}, which does not enforce
substochasticity. Alternatively, \code{1} forces all survival-transition
elements to range from 0.0 to 1.0, and forces fecundity to be non-negative;
and \code{2} forces all column rows in the survival-transition matrices to
total no more than 1.0, in addition to the actions outlined for option
\code{1}. Both settings \code{1} and \code{2} change negative fecundity
elements to \code{0.0}.}

\item{ipm_method}{A string indicating what method to use to estimate size
transition probabilities, if size is treated as continuous. Options include:
\code{"midpoint"}, which utilizes the midpoint method; and \code{"CDF"},
which uses the cumulative distribution function. Defaults to \code{"CDF"}.}

\item{nreps}{The number of replicate projections. Defaults to \code{1}.}

\item{times}{Number of occasions to iterate per replicate. Defaults to
\code{10000}.}

\item{repmod}{A scalar multiplier of fecundity. Defaults to \code{1}.}

\item{exp_tol}{A numeric value used to indicate a maximum value to set
exponents to in the core kernel to prevent numerical overflow. Defaults to
\code{700}.}

\item{theta_tol}{A numeric value used to indicate a maximum value to theta as
used in the negative binomial probability density kernel. Defaults to
\code{100000000}, but can be reset to other values during error checking.}

\item{random_inda}{A logical value denoting whether to treat individual
covariate \code{a} as a random, categorical variable. Otherwise is treated as
a fixed, numeric variable. Defaults to \code{FALSE}.}

\item{random_indb}{A logical value denoting whether to treat individual
covariate \code{b} as a random, categorical variable. Otherwise is treated as
a fixed, numeric variable. Defaults to \code{FALSE}.}

\item{random_indc}{A logical value denoting whether to treat individual
covariate \code{c} as a random, categorical variable. Otherwise is treated as
a fixed, numeric variable. Defaults to \code{FALSE}.}

\item{err_check}{A logical value indicating whether to append extra output
for debugging purposes. Defaults to \code{FALSE}.}

\item{quiet}{A logical value indicating whether warning messages should be
suppressed. Defaults to \code{FALSE}.}

\item{stageframe}{An object of class \code{stageframe}. These objects are
generated by function \code{\link{sf_create}()}, and include information on
the size, observation status, propagule status, reproduction status,
immaturity status, maturity status, stage group, size bin widths, and other
key characteristics of each ahistorical stage. Required for all MPM formats
except Leslie MPMs.}

\item{supplement}{An optional data frame of class \code{lefkoSD} that
provides supplemental data that should be incorporated into the MPM. Three
kinds of data may be integrated this way: transitions to be estimated via the
use of proxy transitions, transition overwrites from the literature or
supplemental studies, and transition multipliers for survival and fecundity.
This data frame should be produced using the \code{\link{supplemental}()}
function. Can be used in place of or in addition to an overwrite table (see 
\code{overwrite} below) and a reproduction matrix (see \code{repmatrix}
below).}

\item{repmatrix}{An optional reproduction matrix. This matrix is composed
mostly of \code{0}s, with non-zero entries acting as element identifiers and
multipliers for fecundity (with \code{1} equaling full fecundity). If left
blank, and no \code{supplement} is provided, then \code{flefko3()} will
assume that all stages marked as reproductive produce offspring at 1x that of
estimated fecundity, and that offspring production will yield the first stage
noted as propagule or immature. May be the dimensions of either a historical
or an ahistorical matrix. If the latter, then all stages will be used in
occasion \emph{t}-1 for each suggested ahistorical transition.}

\item{overwrite}{An optional data frame developed with the
\code{\link{overwrite}()} function describing transitions to be overwritten
either with given values or with other estimated transitions. Note that this
function supplements overwrite data provided in \code{supplement}.}

\item{modelsuite}{A \code{lefkoMod} object, at minimum with all required
best-fit vital rate models and a \code{paramnames} data frame, and following
the naming conventions used in this package. If given, then
\code{surv_model}, \code{obs_model}, \code{size_model}, \code{sizeb_model},
\code{sizec_model}, \code{repst_model}, \code{fec_model}, \code{jsurv_model},
\code{jobs_model}, \code{jsize_model}, \code{jsizeb_model},
\code{jsizec_model}, \code{jrepst_model}, \code{jmatst_model},
\code{paramnames}, \code{yearcol}, and \code{patchcol} are not required.
Although this is optional input, it is recommended, and without it separate
vital rate model inputs (named \code{XX_model}) are required.}

\item{paramnames}{A data frame with three columns, the first describing all
terms used in linear modeling, the second (must be called \code{mainparams})
giving the general model terms that will be used in matrix creation, and the
third showing the equivalent terms used in modeling (must be named
\code{modelparams}). Function \code{\link{create_pm}()} can be used to
create a skeleton \code{paramnames} object, which can then be edited. Only
required if \code{modelsuite} is not supplied.}

\item{year}{Either a single integer value corresponding to the year to
project, or a vector of \code{times} elements with the year to use at each
time step. Defaults to \code{NA}, in which the first year in the set of years
in the dataset is projected. If a vector shorter than \code{times} is
supplied, then this vector will be cycled.}

\item{patch}{A value of \code{NA}, a single string value corresponding to the
patch to project, or a vector of \code{times} elements with the patch to use
at each time step. If a vector shorter than \code{times} is supplied, then
this vector will be cycled. Note that this function currently does not
handle multiple projections for different patches in the same run.}

\item{sp_density}{Either a single numeric value of spatial density to use in
vital rate models in all time steps, or a vector of \code{times} elements of
such numeric values. Defaults to \code{NA}.}

\item{ind_terms}{An optional data frame with 3 columns and \code{times} rows
giving the values of individual covariates a, b, and c, respectively, for
each projected time. Unused terms must be set to \code{0} (use of \code{NA}
will produce errors.)}

\item{dev_terms}{An optional data frame with 14 columns and \code{times}
rows showing the values of the deviation terms to be added to each linear
vital rate. The column order should be: 1: survival, 2: observation, 3:
primary size, 4: secondary size, 5: tertiary size, 6: reproduction, 7:
fecundity, 8: juvenile survival, 9: juvenile observation, 10: juvenile
primary size, 11: juvenile secondary size, 12: juvenile tertiary size, 13:
juvenile reproduction, and 14: juvenile maturity transition.  Unused terms
must be set to \code{0} (use of \code{NA} will produce errors.)}

\item{surv_model}{A linear model predicting survival probability. This can 
be a model of class \code{glm} or \code{glmer}, and requires a predicted
binomial variable under a logit link. Ignored if \code{modelsuite} is
provided. This model must have been developed in a modeling exercise testing
the impacts of occasions \emph{t} and \emph{t}-1.}

\item{obs_model}{A linear model predicting sprouting or observation
probability. This can be a model of class \code{glm} or \code{glmer}, and
requires a predicted binomial variable under a logit link. Ignored if
\code{modelsuite} is provided. This model must have been developed in a
modeling exercise testing the impacts of occasions \emph{t} and \emph{t}-1.}

\item{size_model}{A linear model predicting primary size. This can be a model
of class \code{glm}, \code{glmer}, \code{glmmTMB}, \code{zeroinfl},
\code{vglm}, \code{lm}, or \code{lmer}. Ignored if \code{modelsuite} is
provided. This model must have been developed in a modeling exercise testing
the impacts of occasions \emph{t} and \emph{t}-1.}

\item{sizeb_model}{A linear model predicting secondary size. This can be a
model of class \code{glm}, \code{glmer}, \code{glmmTMB}, \code{zeroinfl},
\code{vglm}, \code{lm}, or \code{lmer}. Ignored if \code{modelsuite} is
provided. This model must have been developed in a modeling exercise testing
the impacts of occasions \emph{t} and \emph{t}-1.}

\item{sizec_model}{A linear model predicting tertiary size. This can be a
model of class \code{glm}, \code{glmer}, \code{glmmTMB}, \code{zeroinfl},
\code{vglm}, \code{lm}, or \code{lmer}. Ignored if \code{modelsuite} is
provided. This model must have been developed in a modeling exercise testing
the impacts of occasions \emph{t} and \emph{t}-1.}

\item{repst_model}{A linear model predicting reproduction probability. This 
can be a model of class \code{glm} or \code{glmer}, and requires a predicted
binomial variable under a logit link. Ignored if \code{modelsuite} is
provided. This model must have been developed in a modeling exercise testing
the impacts of occasions \emph{t} and \emph{t}-1.}

\item{fec_model}{A linear model predicting fecundity. This can be a model of
class \code{glm}, \code{glmer}, \code{glmmTMB}, \code{zeroinfl}, \code{vglm},
\code{lm}, or \code{lmer}. Ignored if \code{modelsuite} is provided. This
model must have been developed in a modeling exercise testing the impacts of
occasions \emph{t} and \emph{t}-1.}

\item{jsurv_model}{A linear model predicting juvenile survival probability.
This can be a model of class \code{glm} or \code{glmer}, and requires a
predicted binomial variable under a logit link. Ignored if \code{modelsuite}
is provided. This model must have been developed in a modeling exercise
testing the impacts of occasions \emph{t} and \emph{t}-1.}

\item{jobs_model}{A linear model predicting juvenile sprouting or observation
probability. This can be a model of class \code{glm} or \code{glmer}, and
requires a predicted binomial variable under a logit link. Ignored if
\code{modelsuite} is provided. This model must have been developed in a
modeling exercise testing the impacts of occasions \emph{t} and \emph{t}-1.}

\item{jsize_model}{A linear model predicting juvenile primary size. This
can be a model of class \code{glm}, \code{glmer}, \code{glmmTMB},
\code{zeroinfl}, \code{vglm}, \code{lm}, or \code{lmer}. Ignored if
\code{modelsuite} is provided. This model must have been developed in a
modeling exercise testing the impacts of occasions \emph{t} and \emph{t}-1.}

\item{jsizeb_model}{A linear model predicting juvenile secondary size. This
can be a model of class \code{glm}, \code{glmer}, \code{glmmTMB},
\code{zeroinfl}, \code{vglm}, \code{lm}, or \code{lmer}. Ignored if
\code{modelsuite} is provided. This model must have been developed in a
modeling exercise testing the impacts of occasions \emph{t} and \emph{t}-1.}

\item{jsizec_model}{A linear model predicting juvenile tertiary size. This
can be a model of class \code{glm}, \code{glmer}, \code{glmmTMB},
\code{zeroinfl}, \code{vglm}, \code{lm}, or \code{lmer}. Ignored if
\code{modelsuite} is provided. This model must have been developed in a
modeling exercise testing the impacts of occasions \emph{t} and \emph{t}-1.}

\item{jrepst_model}{A linear model predicting reproduction probability of a 
mature individual that was immature in time \emph{t}. This can be a model
of class \code{glm} or \code{glmer}, and requires a predicted binomial
variable under a logit link. Ignored if \code{modelsuite} is provided. This
model must have been developed in a modeling exercise testing the impacts of
occasions \emph{t} and \emph{t}-1.}

\item{jmatst_model}{A linear model predicting maturity probability of an 
individual that was immature in time \emph{t}. This can be a model of class
\code{glm} or \code{glmer}, and requires a predicted binomial variable under
a logit link. Ignored if \code{modelsuite} is provided. This model must have
been developed in a modeling exercise testing the impacts of occasions
\emph{t} and \emph{t}-1.}

\item{start_vec}{An optional numeric vector denoting the starting stage
distribution for the projection. Defaults to a single individual of each
stage.}

\item{start_frame}{An optional data frame characterizing stages, age-stages,
or stage-pairs that should be set to non-zero values in the starting vector,
and what those values should be. Can only be used with \code{lefkoMat}
objects.}

\item{tweights}{An optional numeric vector denoting the probabilistic
weightings of year terms. Defaults to equal weighting among occasions.}

\item{density}{An optional data frame describing the matrix elements that
will be subject to density dependence, and the exact kind of density
dependence that they will be subject to. The data frame used should be an
object of class \code{lefkoDens}, which is the output from function
\code{\link{density_input}()}.}

\item{density_vr}{An optional data frame describing density dependence
relationships in vital rates, if such relationships are to be assumed. The
data frame must be of class \code{lefkoDensVR}, which is the output from the
function \code{\link{density_vr}()}.}
}
\value{
A list of class \code{lefkoProj}, which always includes the first
three elements of the following, and also includes the remaining elements
below when a \code{lefkoMat} object is used as input:
\item{projection}{A list of lists of matrices showing the total number of
individuals per stage per occasion. The first list corresponds to each
pop-patch followed by each population (this top-level list is a single
element in \code{f_projection3()}). The inner list corresponds to
replicates within each pop-patch or population.}
\item{stage_dist}{A list of lists of the actual stage distribution in each
occasion in each replicate in each pop-patch or population. The list
structure is the same as in \code{\link{projection3}()}.}
\item{rep_value}{A list of lists of the actual reproductive value in each
occasion in each replicate in each pop-patch or population. The list
structure is the same as in \code{\link{projection3}()}.}
\item{pop_size}{A list of matrices showing the total population size in each
occasion per replicate (row within data frame) per pop-patch or population
(list element). Only a single pop-patch or population is allowed in
\code{f_projection3()}}
\item{labels}{A data frame showing the order of populations and patches in
item \code{projection}.}
\item{ahstages}{The original stageframe used in the study.}
\item{hstages}{A data frame showing the order of historical stage pairs.}
\item{agestages}{A data frame showing the order of age-stage pairs.}
\item{labels}{A short data frame indicating the population (always \code{1},
and patch (either the numeric index of the single chosen patch, or \code{1}
in all other cases).)}
\item{control}{A short vector indicating the number of replicates and the
number of occasions projected per replicate.}
\item{density}{The data frame input under the density option. Only provided
if input by the user.}
\item{density_vr}{The data frame input under the density_vr option. Only
provided if input by the user.}
}
\description{
Function \code{f_projection3()} develops and projects function-based matrix
models. Unlike \code{\link{projection3}()}, which uses matrices provided as
input via already created \code{lefkoMat} objects, function
\code{f_projection3()} creates matrices at each time step from vital rate
models and parameter inputs provided. Projections may be deterministic or
stochastic, and may be density dependent in either case. Replicates may also
be produced.
}
\section{Notes}{

Population projection can be a very time-consuming activity, and it is most
time-consuming when matrices need to be created at each time step. We have
created this function to be as quick as possible, but some options will slow
the analysis down. First, the \code{err_check} option should always be set
to \code{FALSE}, as the added created output will not only slow the analysis
down but also potentially crash the memory if matrices are large enough.
Second, the \code{repvalue} option should be set to \code{FALSE} unless
reproductive values are genuinely needed, since this step requires
concurrent backward projection and so in some cases may double total run
time. Finally, if the only needed data is the total population size and
actual age/stage structure at each time step, then setting \code{growthonly
= TRUE} will yield the quickest possible run time.

Projections with large matrices may take a long time to run. To assess the
likely running time, try using a low number of iterations on a single
replicate first. For example, set \code{nreps = 1} and \code{times = 10} for
a trial run. If a full run is set and takes too long, press the STOP button
in RStudio to cancel the projection run, or click \code{esc}.

This function currently allows three forms of density dependence. The first
modifies matrix elements on the basis of the input provided in option
\code{density}, and so alters matrix elements once the matrix has already
been created. The second form alters the vital rates estimated, and so
estimates matrix elements using vital rate values already modified by
density. This second form uses the input provided in option
\code{density_vr}. These two forms of density dependence utilize the
projected population size at some time to make these alterations. The third
form of density dependence also alters the vital rates, but using spatial
density supplied via option \code{sp_density} and only in vital rates in
which spatial density is included as a fixed factor in the associated
vital rate model.

Consistently positive population growth can quickly lead to population size
numbers larger than can be handled computationally. In that circumstance, a
continuously rising population size will suddenly become \code{NaN} for the
remainder of the projection.

This function does not reduce the dimensionality of matrices developed for
projection.
}

\examples{
\donttest{
# Lathyrus projection example with historical matrices
data(lathyrus)

sizevector <- c(0, 4.6, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 6, 7, 8,
  9)
stagevector <- c("Sd", "Sdl", "Dorm", "Sz1nr", "Sz2nr", "Sz3nr", "Sz4nr",
  "Sz5nr", "Sz6nr", "Sz7nr", "Sz8nr", "Sz9nr", "Sz1r", "Sz2r", "Sz3r", 
  "Sz4r", "Sz5r", "Sz6r", "Sz7r", "Sz8r", "Sz9r")
repvector <- c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1)
obsvector <- c(0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0)
indataset <- c(0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 4.6, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 
  0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5)

lathframeln <- sf_create(sizes = sizevector, stagenames = stagevector, 
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector, 
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec, 
  propstatus = propvector)

lathvertln <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9, 
  juvcol = "Seedling1988", sizeacol = "lnVol88", repstracol = "Intactseed88",
  fecacol = "Intactseed88", deadacol = "Dead1988", 
  nonobsacol = "Dormant1988", stageassign = lathframeln, stagesize = "sizea",
  censorcol = "Missing1988", censorkeep = NA, NAas0 = TRUE, censor = TRUE)

lathvertln$feca2 <- round(lathvertln$feca2)
lathvertln$feca1 <- round(lathvertln$feca1)
lathvertln$feca3 <- round(lathvertln$feca3)

lathmodelsln3 <- modelsearch(lathvertln, historical = TRUE, 
  approach = "mixed", suite = "main", 
  vitalrates = c("surv", "obs", "size", "repst", "fec"), juvestimate = "Sdl",
  bestfit = "AICc&k", sizedist = "gaussian", fecdist = "poisson", 
  indiv = "individ", patch = "patchid", year = "year2", year.as.random = TRUE,
  patch.as.random = TRUE, show.model.tables = TRUE, quiet = TRUE)

lathsupp3 <- supplemental(stage3 = c("Sd", "Sd", "Sdl", "Sdl", "mat", "Sd", "Sdl"), 
  stage2 = c("Sd", "Sd", "Sd", "Sd", "Sdl", "rep", "rep"),
  stage1 = c("Sd", "rep", "Sd", "rep", "Sd", "mat", "mat"),
  eststage3 = c(NA, NA, NA, NA, "mat", NA, NA),
  eststage2 = c(NA, NA, NA, NA, "Sdl", NA, NA),
  eststage1 = c(NA, NA, NA, NA, "Sdl", NA, NA),
  givenrate = c(0.345, 0.345, 0.054, 0.054, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, NA, 0.345, 0.054),
  type = c(1, 1, 1, 1, 1, 3, 3), type_t12 = c(1, 2, 1, 2, 1, 1, 1),
  stageframe = lathframeln, historical = TRUE)

# While we do not use MPMs to initialize f_projections3(), we do use MPMs to
# initialize functions start_input() and density_input().
lathmat3ln <- flefko3(year = "all", patch = "all", stageframe = lathframeln, 
  modelsuite = lathmodelsln3, data = lathvertln, supplement = lathsupp3, 
  reduce = FALSE)

e3m_sv <- start_input(lathmat3ln, stage2 = "Sd", stage1 = "Sd", value = 1000)

e3d <- density_input(lathmat3ln, stage3 = c("Sd", "Sdl"),
  stage2 = c("rep", "rep"), stage1 = c("all", "all"), style = 1,
  time_delay = 1, alpha = 1, beta = 0, type = c(2, 2), type_t12 = c(1, 1))

trial7 <- f_projection3(format = 1, data = lathvertln,
  modelsuite = lathmodelsln3, stageframe = lathframeln, nreps = 2,
  times = 1000, stochastic = TRUE, standardize = FALSE, growthonly = TRUE,
  integeronly = FALSE, substoch = 0)
summary(trial7)

# Now with density dependence and a set start vector
trial7a <- f_projection3(format = 1, data = lathvertln,
  modelsuite = lathmodelsln3, stageframe = lathframeln, nreps = 2,
  times = 1000, stochastic = TRUE, standardize = FALSE, growthonly = TRUE,
  integeronly = FALSE, substoch = 0, sp_density = 0, start_frame = e3m_sv,
  density = e3d)
summary(trial7a)
}

}
\seealso{
\code{\link{projection3}()}

\code{\link{flefko3}()}

\code{\link{flefko2}()}

\code{\link{aflefko2}()}

\code{\link{fleslie}()}
}
