% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legion-package.R
\docType{package}
\name{legion}
\alias{legion}
\title{Legion package}
\description{
Package contains functions for multivariate time series forecasting
}
\details{
\tabular{ll}{ Package: \tab legion\cr Type: \tab Package\cr Date: \tab
2021-02-18 - Inf\cr License: \tab GPL-2 \cr } The following functions are
included in the package:
\itemize{
\item \link[legion]{ves} - Vector Exponential Smoothing.
\item \link[legion]{ves} - Vector ETS-PIC model.
\item \link[legion]{oves} - Multivariate occurrence ETS model.
}
}
\examples{

\dontrun{y <- cbind(rnorm(100,10,3),rnorm(100,10,3))

ves(y,h=20,holdout=TRUE)}

}
\references{
\itemize{
\item de Silva A., Hyndman R.J. and Snyder, R.D. (2010). The vector
innovations structural time series framework: a simple approach to
multivariate forecasting. Statistical Modelling, 10 (4), pp.353-374
\item Hyndman, R.J., Koehler, A.B., Ord, J.K., and Snyder, R.D. (2008)
Forecasting with exponential smoothing: the state space approach,
Springer-Verlag.
\item Lütkepohl, H. (2005). New Introduction to Multiple Time Series
Analysis. New introduction to Multiple Time Series Analysis. Berlin,
Heidelberg: Springer Berlin Heidelberg.
\doi{10.1007/978-3-540-27752-1}
\item Chen H., Svetunkov I., Boylan J. (2021). A New Taxonomy for
Vector Exponential Smoothing and Its Application to Seasonal Time
Series.
}
}
\seealso{
\code{\link[greybox]{forecast}, \link[smooth]{es}, \link[smooth]{adam}}
}
\author{
Ivan Svetunkov

Kandrika Pritularga

Maintainer: Ivan Svetunkov <ivan@svetunkov.ru>
}
\keyword{models}
\keyword{multivariate}
\keyword{nonlinear}
\keyword{regression}
\keyword{ts}
