# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Refer to the R function find_partition()
#' For notes of the graph object, refer to https://igraph.org/c/doc/igraph-Basic.html
#'
#' @param edgelist The graph edge list
#' @param edgelist_length integer The length of the graph edge list
#' @param num_vertices integer The number of vertices in the graph
#' @param direction boolean Whether the graph is directed or undirected
#' @param edge_weights Vector of edge weights. In weighted graphs, a real number is assigned to each (directed or undirected) edge. For an unweighted graph, this is set to 1. Refer to igraph, weighted graphs.
#' @param resolution Integer resoluiton parameter controlling communities detected (default=1.0) Higher resolutions lead to more communities, while lower resolutions lead to fewer communities.
#' @param niter Number of iterations that the algorithm should be run for (default=2)
#' @return A vector of membership values
#' @examples 
#' library(igraph)
#' library(leidenAlg)
#' 
#' g <- make_star(10)
#' E(g)$weight <- seq(ecount(g))
#' find_partition(g, E(g)$weight)
#' 
find_partition_rcpp <- function(edgelist, edgelist_length, num_vertices, direction, edge_weights, resolution = 1.0, niter = 2L) {
    .Call('_leidenAlg_find_partition_rcpp', PACKAGE = 'leidenAlg', edgelist, edgelist_length, num_vertices, direction, edge_weights, resolution, niter)
}

