## ---------------------------------------------------------------------------------------------------------------------
library("lessR")

## ---------------------------------------------------------------------------------------------------------------------
d <- Read("Mach4", quiet=TRUE)
l <- Read("Mach4_lbl", var_labels=TRUE)

## ----fig.width=4.5, fig.height=4.5------------------------------------------------------------------------------------
mycor <- cr(m01:m20)
R <- mycor$R

## ---------------------------------------------------------------------------------------------------------------------
efa(R, n_factors=4)

## ---------------------------------------------------------------------------------------------------------------------
MeasModel <- 
" 
   Deceit =~ m07 + m06 + m10 + m09 
   Trust =~ m12 + m05 + m13 + m01 
   Cynicism =~ m11 + m16 + m04 
   Flattery =~ m15 + m02 
"

## ----fig.width=4.5, fig.height=4.5------------------------------------------------------------------------------------
cfa_out <- cfa(MeasModel, R)
cfa_out

## ---------------------------------------------------------------------------------------------------------------------
names(cfa_out)

## ---------------------------------------------------------------------------------------------------------------------
cfa_out$out_reliability

## ---------------------------------------------------------------------------------------------------------------------
cfa(MeasModel, labels="only")

## ----fig.width=4.5, fig.height=4.5------------------------------------------------------------------------------------
corReorder(n_clusters=5)

## ---------------------------------------------------------------------------------------------------------------------
R2 <- corReorder(vars=c(6,7,9,10,15,2))
R2

