#' Language Assessment by Mechanical Turk Sentiment Words
#'
#' A dataset containing words, average happiness score (polarity), standard
#' deviations, and rankings.
#'
#' @details
#' \itemize{
#'   \item word. The word.
#'   \item happiness_rank. Happiness ranking of words based on average happiness
#'   scores.
#'   \item happiness_average. Average happiness score.
#'   \item happiness_standard_deviation. Standard deviations of the happiness
#'   scores.
#'   \item twitter_rank. Twitter ranking of the word.
#'   \item google_rank. Google ranking of the word.
#'   \item nyt_rank. New York Times ranking of the word.
#'   \item lyrics_rank. lyrics ranking of the word.
#' }
#'
#' @docType data
#' @keywords datasets
#' @name dodds_sentiment
#' @usage data(dodds_sentiment)
#' @format A data frame with 10222 rows and 8 variables
#' @references
#' Dodds, P.S., Harris, K.D., Kloumann, I.M., Bliss, C.A., & Danforth, C.M. (2011)
#' Temporal patterns of happiness and information in a global social network:
#' Hedonometrics and twitter. PLoS ONE 6(12): e26752.
#' doi:10.1371/journal.pone.0026752
#'
#' http://www.plosone.org/article/fetchSingleRepresentation.action?uri=info:doi/10.1371/journal.pone.0026752.s001
NULL
