% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/farules.R
\name{farules}
\alias{farules}
\title{Create an instance of S3 class \code{farules} which represents a set of fuzzy
association rules and their statistical characteristics.}
\usage{
farules(rules, statistics)
}
\arguments{
\item{rules}{A list of character vectors, where each vector represents a
rule and each value of the vector represents a predicate. The first value of
the vector is assumed to be a rule's consequent, the rest is a rule's antecedent.}

\item{statistics}{A numeric matrix of various statistical characteristics of
the rules. Each column of that matrix corresponds to some statistic (such as
support, confidence, etc.) and each row corresponds to a rule in the list of
\code{rules}.}
}
\value{
Returns an object of class \code{farules}.
}
\description{
This function is a constructor that returns an instance of the \code{farules} S3 class.
To search for fuzzy association rules, refer to the \code{\link[=searchrules]{searchrules()}} function.
}
\seealso{
\code{\link[=searchrules]{searchrules()}}
}
\author{
Michal Burda
}
\keyword{models}
\keyword{robust}
