% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcutDeprecated.R
\name{lcut3}
\alias{lcut3}
\alias{lcut5}
\alias{lcut3.default}
\alias{lcut5.default}
\alias{lcut3.numeric}
\alias{lcut5.numeric}
\alias{lcut3.data.frame}
\alias{lcut5.data.frame}
\alias{lcut3.matrix}
\alias{lcut5.matrix}
\title{Deprecated functions for transformation of data into a \code{fsets} S3 class of linguistic fuzzy attributes}
\usage{
lcut3(x, ...)

lcut5(x, ...)

\method{lcut3}{default}(x, ...)

\method{lcut5}{default}(...)

\method{lcut3}{numeric}(
  x,
  context = NULL,
  defaultCenter = 0.5,
  atomic = c("sm", "me", "bi"),
  hedges = c("ex", "si", "ve", "ml", "ro", "qr", "vr"),
  name = NULL,
  parallel = FALSE,
  ...
)

\method{lcut5}{numeric}(
  x,
  context = NULL,
  defaultCenter = 0.5,
  atomic = c("sm", "lm", "me", "um", "bi"),
  hedges = c("ex", "ve", "ml", "ro", "ty"),
  name = NULL,
  parallel = FALSE,
  ...
)

\method{lcut3}{data.frame}(x, context = NULL, name = NULL, parallel = FALSE, ...)

\method{lcut5}{data.frame}(x, context = NULL, name = NULL, parallel = FALSE, ...)

\method{lcut3}{matrix}(x, ...)

\method{lcut5}{matrix}(x, ...)
}
\arguments{
\item{x}{Data to be transformed: if it is a numeric vector, matrix, or data
frame, then the creation of linguistic fuzzy attributes takes place. For
other data types the \code{\link[=fcut]{fcut()}} function is called implicitly.}

\item{...}{Other parameters to some methods.}

\item{context}{A definition of context of a numeric attribute. Context
determines how people understand the notions "small", "medium", or "big"
with respect to that attribute. If \code{x} is a numeric vector then context
should be a vector of 3 numbers:
typical small, medium, and big value. If the context is set to NULL, these values
are taken directly from \code{x} as follows:
\itemize{
\item small: \eqn{= min(x)};
\item medium: \eqn{= (max(x) - min(x)) * defaultCenter + min(x)};
\item big: \eqn{= max(x)}.
If \code{x} is a matrix or data frame then \code{context} should be a named list
of contexts for each \code{x}'s column. If some context is omitted, it will be determined
directly from data as explained above.
}

Regardless of the value of the \code{atomic} argument, all 3 numbers of the context
must be provided everytime.}

\item{defaultCenter}{A value used to determine a typical "medium" value from
data (see \code{context} above). If \code{context} is not specified then typical "medium"
is determined as \deqn{(max(x) - min(x)) * defaultCenter + min(x).}
Default value of \code{defaultCenter} is 0.5, however, some literature specifies
0.42 as another sensible value with proper linguistic interpretation.}

\item{atomic}{A vector of atomic linguistic expressions to be used for
creation of fuzzy attributes.}

\item{hedges}{A vector of linguistic hedges to be used for creation of fuzzy
attributes.}

\item{name}{A name to be added as a suffix to the created fuzzy attribute
names. This parameter can be used only if \code{x} is a numeric vector. If
\code{x} is a matrix or data frame, \code{name} should be NULL because the
fuzzy attribute names are taken from column names of parameter \code{x}.
The \code{name} is also used as a value for the \code{vars} attribute of the resulting
\code{\link[=fsets]{fsets()}} instance.}

\item{parallel}{Whether the processing should be run in parallel or not.
Parallelization is implemented using the \code{\link[foreach:foreach]{foreach::foreach()}} function.
The parallel environment must be set properly in advance, e.g. with the
\code{\link[doMC:registerDoMC]{doMC::registerDoMC()}} function.}
}
\value{
An object of S3 class \code{fsets} is returned, which is a numeric matrix
with columns representing the fuzzy attributes. Each source columm of the
\code{x} argument corresponds to multiple columns in the resulting matrix.
Columns will have names derived from used \eqn{hedges}, atomic expression,
and \eqn{name} specified as the optional parameter.

The resulting object would also have set the \code{\link[=vars]{vars()}} and \code{\link[=specs]{specs()}}
properties with the former being created from original
column names (if \code{x} is a matrix or data frame) or the \code{name}
argument (if \code{x} is a numeric vector). The \code{\link[=specs]{specs()}}
incidency matrix would be created to reflect the following order of the
hedges: \eqn{"ex" < "si" < "ve" < "-" < "ml" < "ro" < "qr" < "vr"} and
\eqn{"ty" < "" < "ml" < "ro" < "qr" < "vr"}.  Fuzzy attributes created from
the same source numeric vector (or column) would be ordered that way, with other fuzzy attributes
(from the other source) being incomparable.
}
\description{
These functions are deprecated. Please use \code{\link[=lcut]{lcut()}} or \code{\link[=fcut]{fcut()}} instead.
}
\author{
Michal Burda
}
\keyword{models}
\keyword{robust}
