% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LayoutDbi.R
\name{LayoutDbi}
\alias{LayoutDbi}
\alias{LayoutSqlite}
\alias{LayoutRjdbc}
\alias{LayoutRjdbcDb2}
\alias{LayoutDb2}
\alias{LayoutMySql}
\alias{LayoutPostgres}
\title{Format log events for output to databases}
\value{
The \verb{$new()} method returns an \link[R6:R6Class]{R6::R6} that inherits from
\link[lgr:Layout]{lgr::Layout} and can used as a Layout by an \link[lgr:Appender]{lgr::Appender}.
}
\description{
LayoutDbi can contain \code{col_types} that \link{AppenderDbi} can use to create new
database tables; however, it is safer and more flexible to set up the log
table up manually with an \verb{SQL CREATE TABLE} statement instead.
}
\details{
The LayoutDbi parameters \code{fmt}, \code{timestamp_fmt}, \code{colors} and \code{pad_levels}
are only applied for for console output via the \verb{$show()} method and do not
influence database inserts in any way. The inserts are pre-processed by
the methods \verb{$format_data()}, \verb{$format_colnames} and \verb{$format_tablenames}.

It does not format
LogEvents directly, but their \code{data.table} representations (see
\link{as.data.table.LogEvent}), as well as column- and table names.
}
\section{Database Specific Layouts}{


Different databases have different data types and features. Currently the
following \code{LayoutDbi} subclasses exist that deal with specific databases,
but this list is expected to grow as lgrExtra matures:
\itemize{
\item \code{LayoutSqlite}: For SQLite databases
\item \code{LayoutPostgres}: for Postgres databases
\item \code{LayoutMySql}: for MySQL databases
\item \code{LayoutDb2}: for DB2 databases
}

The utility function \code{\link[=select_dbi_layout]{select_dbi_layout()}} tries returns the appropriate
Layout for a DBI connection, but this does not work for odbc and JDBC
connections where you have to specify the layout manually.

For creating custom DB-specific layouts it should usually be enough to create
an \link[R6:R6Class]{R6::R6} class that inherits from \code{LayoutDbi} and choosing different
defaults for \verb{$format_table_name}, \verb{$format_colnames} and \verb{$format_data}.
}

\seealso{
\code{\link[=select_dbi_layout]{select_dbi_layout()}}, \link[DBI:DBI-package]{DBI::DBI},

Other Layout: 
\code{\link{LayoutElasticSearch}}
}
\concept{Layout}
\concept{database layouts}
\section{Super classes}{
\code{\link[lgr:Layout]{lgr::Layout}} -> \code{\link[lgr:LayoutFormat]{lgr::LayoutFormat}} -> \code{LayoutDbi}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{format_table_name}}{a \code{function} to format the table name before
inserting to the database. The function will be applied to the
\verb{$table_name} before inserting into the database. For example some,
databases prefer all lowercase names, some uppercase. SQL updates
should be case-agnostic, but sadly in practice not all DBI backends
behave consistently in this regard.}

\item{\code{format_colnames}}{a \code{function} to format the column names before
inserting to the database. The function will be applied to the column
names of the data frame to be inserted into the database.}

\item{\code{format_data}}{a \code{function} to format the data before
inserting into the database. The function will be applied to the whole
data frame.}

\item{\code{names}}{of the columns that contain data that has been serialized
to JSON strings}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{col_types}}{a named \code{character} vector of column types supported by
the target database. If not \code{NULL} this is used by \link{AppenderDbi} or
similar Appenders to create a new database table on instantiation of
the Appender. If the target database table already exists, \code{col_types}
is not used.}

\item{\code{names}}{of the columns that contain data that has been serialized
to JSON strings}

\item{\code{col_names}}{column names of the target table (the same as
\code{names(lo$col_types)})}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{LayoutDbi$new()}}
\item \href{#method-set_col_types}{\code{LayoutDbi$set_col_types()}}
\item \href{#method-set_serialized_cols}{\code{LayoutDbi$set_serialized_cols()}}
\item \href{#method-sql_create_table}{\code{LayoutDbi$sql_create_table()}}
\item \href{#method-toString}{\code{LayoutDbi$toString()}}
\item \href{#method-clone}{\code{LayoutDbi$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="LayoutFormat" data-id="format_event">}\href{../../lgr/html/LayoutFormat.html#method-format_event}{\code{lgr::LayoutFormat$format_event()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="LayoutFormat" data-id="read">}\href{../../lgr/html/LayoutFormat.html#method-read}{\code{lgr::LayoutFormat$read()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="LayoutFormat" data-id="set_colors">}\href{../../lgr/html/LayoutFormat.html#method-set_colors}{\code{lgr::LayoutFormat$set_colors()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="LayoutFormat" data-id="set_fmt">}\href{../../lgr/html/LayoutFormat.html#method-set_fmt}{\code{lgr::LayoutFormat$set_fmt()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="LayoutFormat" data-id="set_pad_levels">}\href{../../lgr/html/LayoutFormat.html#method-set_pad_levels}{\code{lgr::LayoutFormat$set_pad_levels()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="LayoutFormat" data-id="set_timestamp_fmt">}\href{../../lgr/html/LayoutFormat.html#method-set_timestamp_fmt}{\code{lgr::LayoutFormat$set_timestamp_fmt()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayoutDbi$new(
  col_types = c(level = "integer", timestamp = "timestamp", logger = "varchar(256)",
    caller = "varchar(256)", msg = "varchar(2048)"),
  serialized_cols = NULL,
  fmt = "\%L [\%t] \%m  \%f",
  timestamp_fmt = "\%Y-\%m-\%d \%H:\%M:\%S",
  colors = getOption("lgr.colors", list()),
  pad_levels = "right",
  format_table_name = identity,
  format_colnames = identity,
  format_data = data.table::as.data.table
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_col_types"></a>}}
\if{latex}{\out{\hypertarget{method-set_col_types}{}}}
\subsection{Method \code{set_col_types()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayoutDbi$set_col_types(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_serialized_cols"></a>}}
\if{latex}{\out{\hypertarget{method-set_serialized_cols}{}}}
\subsection{Method \code{set_serialized_cols()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayoutDbi$set_serialized_cols(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sql_create_table"></a>}}
\if{latex}{\out{\hypertarget{method-sql_create_table}{}}}
\subsection{Method \code{sql_create_table()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayoutDbi$sql_create_table(table)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-toString"></a>}}
\if{latex}{\out{\hypertarget{method-toString}{}}}
\subsection{Method \code{toString()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayoutDbi$toString()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayoutDbi$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
