% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lccall-subject.R
\name{get_all_lc_call_subject_letters}
\alias{get_all_lc_call_subject_letters}
\title{Get all subject letters of LC Call Number}
\usage{
get_all_lc_call_subject_letters(x)
}
\arguments{
\item{x}{A Library of Congress call number (string)}
}
\value{
Returns all the subject letters or NA if invalid
}
\description{
Takes a string representation of a Library of Congress
call number and returns all the subject letters if and only if
the LC Call Number is valid
}
\examples{

get_all_lc_call_subject_letters("Q172.5.E77")
# Q
get_all_lc_call_subject_letters("AF172.5.E77")
# NA

# vectorized
get_all_lc_call_subject_letters(c("Q 172.5", "AF172", "PR6023.A93"))
# Q NA PR

}
