% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibcodes.R
\name{is_valid_isbn_10}
\alias{is_valid_isbn_10}
\title{Return TRUE if valid ISBN 10}
\usage{
is_valid_isbn_10(x, allow.hyphens = TRUE, lower.x.allowed = TRUE)
}
\arguments{
\item{x}{A string of 10 digits or 9 digits with terminal "X"}

\item{allow.hyphens}{A logical indicating whether the hyphen
separator should be allowed}

\item{lower.x.allowed}{A logical indicating whether ISBN 10s with
a check digit with a lower-case "x" should
be treated as valid}
}
\value{
Returns TRUE if checks pass, FALSE if not, and NA if NA
}
\description{
Takes a string representation of an ISBN 10 verifies that it is valid.
An ISBN 10 is valid if it is a 10 digit string or a 9 digit string
with a terminal "X" AND the check digit matches
}
\examples{

is_valid_isbn_10("012491540X")    # TRUE
is_valid_isbn_10("0-124-91540-X") # TRUE

# vectorized
is_valid_isbn_10(c("012491540X", "9004037812"))      # TRUE FALSE
is_valid_isbn_10(c("012491540X", "hubo un tiempo"))  # TRUE FALSE

}
