% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{is.lib}
\alias{is.lib}
\title{Class test for a data library}
\usage{
is.lib(x)
}
\arguments{
\item{x}{The object to test.}
}
\value{
TRUE or FALSE, depending on whether or not the object is a 
data library.
}
\description{
This function tests whether an object is a data library.  The
data library has a class of "lib".
}
\examples{
# Create format catalog
libname(dat, tempdir()) 
           
# Test for "lib" class
is.lib(dat) 
# [1] TRUE

is.lib(list())
# [1] FALSE

# Clean up
lib_delete(dat)
}
\seealso{
Other lib: 
\code{\link{lib_add}()},
\code{\link{lib_copy}()},
\code{\link{lib_delete}()},
\code{\link{lib_info}()},
\code{\link{lib_load}()},
\code{\link{lib_path}()},
\code{\link{lib_remove}()},
\code{\link{lib_replace}()},
\code{\link{lib_size}()},
\code{\link{lib_sync}()},
\code{\link{lib_unload}()},
\code{\link{lib_write}()},
\code{\link{libname}()},
\code{\link{print.lib}()}
}
\concept{lib}
