/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

#include <R.h>
#include <Rdefines.h>
#include <so.h>
#include "soc.h"

SEXP r_so_SO_new()
{
	so_SO *obj = so_SO_new();
	if (!obj) {
		error("Failed to create so_SO object");
	}
	return R_MakeExternalPtr(obj, R_NilValue, R_NilValue);
}

SEXP r_so_SO_copy(SEXP self)
{
	so_SO *obj = so_SO_copy(R_ExternalPtrAddr(self));
	if (!obj) {
		error("Failed to copy so_SO object");
	}
	return R_MakeExternalPtr(obj, R_NilValue, R_NilValue);
}

SEXP r_so_SO_free(SEXP self)
{
	so_SO_free(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_SO_ref(SEXP self)
{
	so_SO_ref(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_SO_unref(SEXP self)
{
	so_SO_unref(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_SO_get_Description(SEXP self)
{
	char *child = so_SO_get_Description(R_ExternalPtrAddr(self));
	if (!child) {
		return R_NilValue;
	}
	SEXP result;
	PROTECT(result = NEW_STRING(1));
	SET_STRING_ELT(result, 0, mkChar(child));
	UNPROTECT(1);
	return result;
}

SEXP r_so_SO_set_Description(SEXP self, SEXP child)
{
	int fail = so_SO_set_Description(R_ExternalPtrAddr(self), (char *) CHAR(STRING_ELT(child, 0)));
	if (fail) {
		error("so_SO_set_Description failed");
	}
	return R_NilValue;
}


SEXP r_so_SO_get_PharmMLRef(SEXP self)
{
	so_PharmMLRef *child = so_SO_get_PharmMLRef(R_ExternalPtrAddr(self));
	SEXP result = R_MakeExternalPtr(child, R_NilValue, R_NilValue);
	return result;
}

SEXP r_so_SO_set_PharmMLRef(SEXP self, SEXP child)
{
	so_SO_set_PharmMLRef(R_ExternalPtrAddr(self), R_ExternalPtrAddr(child));
	return R_NilValue;
}

SEXP r_so_SO_create_PharmMLRef(SEXP self)
{
	so_PharmMLRef *child = so_SO_create_PharmMLRef(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

SEXP r_so_SO_get_SOBlock(SEXP self, SEXP index)
{
	so_SOBlock *child = so_SO_get_SOBlock(R_ExternalPtrAddr(self), INTEGER(index)[0]);
	SEXP result = R_MakeExternalPtr(child, R_NilValue, R_NilValue);
	return result;
}

SEXP r_so_SO_get_number_of_SOBlock(SEXP self)
{
	int number = so_SO_get_number_of_SOBlock(R_ExternalPtrAddr(self));
	SEXP r_int = PROTECT(NEW_INTEGER(1));
	INTEGER(r_int)[0] = number;
	UNPROTECT(1);
	return r_int;
}
SEXP r_so_SO_add_SOBlock(SEXP self, SEXP child)
{
	int fail = so_SO_add_SOBlock(R_ExternalPtrAddr(self), R_ExternalPtrAddr(child));
	if (fail) {
		error("Failed to add SOBlock to SO");
	}
	return(R_NilValue);
}
SEXP r_so_SO_remove_SOBlock(SEXP self, SEXP index)
{
	int fail = so_SO_remove_SOBlock(R_ExternalPtrAddr(self), INTEGER(index)[0]);
	if (fail) {
		error("Failed to remove SOBlock from SO");
	}
	return(R_NilValue);
}
SEXP r_so_SO_create_SOBlock(SEXP self)
{
	so_SOBlock *child = so_SO_create_SOBlock(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

SEXP r_so_SO_get_id(SEXP self)
{
	char *value = so_SO_get_id(R_ExternalPtrAddr(self));

	SEXP result;

	if (value) {
		result = PROTECT(NEW_STRING(1));
		SET_STRING_ELT(result, 0, mkChar(value));

		UNPROTECT(1);
	} else {
		result = R_NilValue;
	}
	return result;
}

SEXP r_so_SO_set_id(SEXP self, SEXP string)
{
	char *c_string = (char *) CHAR(STRING_ELT(string, 0));
	int fail = so_SO_set_id(R_ExternalPtrAddr(self), c_string);
	if (fail) {
		error("so_SO_set_id failed");
	}

	return R_NilValue;
}

SEXP r_so_SO_get_metadataFile(SEXP self)
{
	char *value = so_SO_get_metadataFile(R_ExternalPtrAddr(self));

	SEXP result;

	if (value) {
		result = PROTECT(NEW_STRING(1));
		SET_STRING_ELT(result, 0, mkChar(value));

		UNPROTECT(1);
	} else {
		result = R_NilValue;
	}
	return result;
}

SEXP r_so_SO_set_metadataFile(SEXP self, SEXP string)
{
	char *c_string = (char *) CHAR(STRING_ELT(string, 0));
	int fail = so_SO_set_metadataFile(R_ExternalPtrAddr(self), c_string);
	if (fail) {
		error("so_SO_set_metadataFile failed");
	}

	return R_NilValue;
}

