/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#ifndef _SO_INDIVIDUALESTIMATES_H
#define _SO_INDIVIDUALESTIMATES_H

#include <so/Estimates.h>
#include <so/RandomEffects_IE.h>
#include <so/Table.h>

/** \struct so_IndividualEstimates
	 \brief A structure representing an SO/SOBlock/Estimation/IndividualEstimates element
*/
typedef struct so_IndividualEstimates so_IndividualEstimates;

/** \memberof so_IndividualEstimates
 * Create a new empty so_IndividualEstimates structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_IndividualEstimates_copy, so_IndividualEstimates_free
 */
so_IndividualEstimates *so_IndividualEstimates_new();
/** \memberof so_IndividualEstimates
 * Create a copy of a so_IndividualEstimates structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_IndividualEstimates_new
 */
so_IndividualEstimates *so_IndividualEstimates_copy(so_IndividualEstimates *self);
/** \memberof so_IndividualEstimates
 * Free all memory associated with a so_IndividualEstimates structure and its children.
 * \param self - a pointer to the structure to free
 * \sa so_IndividualEstimates_new
 */
void so_IndividualEstimates_free(so_IndividualEstimates *self);
void so_IndividualEstimates_ref(so_IndividualEstimates *self);
void so_IndividualEstimates_unref(so_IndividualEstimates *self);
/** \memberof so_IndividualEstimates
 * Get the Estimates element
 * \param self - pointer to a so_IndividualEstimates
 * \return A pointer to the structure representing the Estimates element
 * \sa so_IndividualEstimates_set_Estimates
 */
so_Estimates *so_IndividualEstimates_get_Estimates(so_IndividualEstimates *self);
/** \memberof so_IndividualEstimates
 * Get the RandomEffects element
 * \param self - pointer to a so_IndividualEstimates
 * \return A pointer to the structure representing the RandomEffects element
 * \sa so_IndividualEstimates_set_RandomEffects
 */
so_RandomEffects_IE *so_IndividualEstimates_get_RandomEffects(so_IndividualEstimates *self);
/** \memberof so_IndividualEstimates
 * Get the EtaShrinkage element
 * \param self - pointer to a so_IndividualEstimates
 * \return A pointer to the structure representing the EtaShrinkage element
 * \sa so_IndividualEstimates_set_EtaShrinkage
 */
so_Table *so_IndividualEstimates_get_EtaShrinkage(so_IndividualEstimates *self);
/** \memberof so_IndividualEstimates
 * Set the Estimates element
 * \param self - pointer to a so_IndividualEstimates
 * \param value - A pointer to a \a so_Estimates to set.
 * \sa so_IndividualEstimates_get_Estimates
 */
void so_IndividualEstimates_set_Estimates(so_IndividualEstimates *self, so_Estimates *value);
/** \memberof so_IndividualEstimates
 * Set the RandomEffects element
 * \param self - pointer to a so_IndividualEstimates
 * \param value - A pointer to a \a so_RandomEffects_IE to set.
 * \sa so_IndividualEstimates_get_RandomEffects
 */
void so_IndividualEstimates_set_RandomEffects(so_IndividualEstimates *self, so_RandomEffects_IE *value);
/** \memberof so_IndividualEstimates
 * Set the EtaShrinkage element
 * \param self - pointer to a so_IndividualEstimates
 * \param value - A pointer to a \a so_Table to set.
 * \sa so_IndividualEstimates_get_EtaShrinkage
 */
void so_IndividualEstimates_set_EtaShrinkage(so_IndividualEstimates *self, so_Table *value);
/** \memberof so_IndividualEstimates
 * Create a new Estimates element and insert it into the so_IndividualEstimates
 * \param self - pointer to a so_IndividualEstimates
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Estimates *so_IndividualEstimates_create_Estimates(so_IndividualEstimates *self);
/** \memberof so_IndividualEstimates
 * Create a new RandomEffects element and insert it into the so_IndividualEstimates
 * \param self - pointer to a so_IndividualEstimates
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_RandomEffects_IE *so_IndividualEstimates_create_RandomEffects(so_IndividualEstimates *self);
/** \memberof so_IndividualEstimates
 * Create a new EtaShrinkage element and insert it into the so_IndividualEstimates
 * \param self - pointer to a so_IndividualEstimates
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Table *so_IndividualEstimates_create_EtaShrinkage(so_IndividualEstimates *self);

#endif
