% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasnormalize.r
\name{lasnormalize}
\alias{lasnormalize}
\title{Subtract digital terrain model}
\usage{
lasnormalize(.las, dtm)
}
\arguments{
\item{.las}{a LAS objet}

\item{dtm}{a \link[raster:raster]{RasterLayer} or a \code{lasmetrics} object.
\link[lidR:grid_terrain]{grid_terrain}.}
}
\value{
A LAS object.
}
\description{
Subtract digital terrain model (DTM) from the LiDAR data to create a dataset
normalized with the ground at 0. The digital terrain model can originate from
several sources e.g. from an external file or computed by the user. It can also be computed on the
fly.
}
\examples{
LASfile <- system.file("extdata", "Topography.laz", package="lidR")
lidar = readLAS(LASfile)

plot(lidar)

# --- First option: compute the DTM with grid_terrain -----

dtm = grid_terrain(lidar, method = "delaunay")
lidar_norm = lasnormalize(lidar, dtm)
plot(dtm)
plot(lidar_norm)

\dontrun{
# --- Second option: read the DTM from a file -----

dtm = raster::raster(terrain.tiff)
lidar_norm = lidar - dtm
plot(lidar_norm)
}
}
\seealso{
\link[raster:raster]{raster}
\link[lidR:grid_terrain]{grid_terrain}
}
