% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasground.r
\name{lasground}
\alias{lasground}
\title{Classify points as ground or not ground}
\usage{
lasground(.las, MaxWinSize = 20, Slope = 1, InitDist = 0.5, MaxDist = 3,
  CellSize = 1, ...)
}
\arguments{
\item{.las}{a LAS object}

\item{MaxWinSize}{numeric. Maximum window size to be used in filtering ground returns (see references)}

\item{Slope}{numeric. Slope value to be used in computing the height thresholds (see references)}

\item{InitDist}{numeric. Initial height above the parameterized ground surface to be considered a ground return (see references)}

\item{MaxDist}{numeric. Maximum height above the parameterized ground surface to be considered a ground return (see references)}

\item{CellSize}{numeric. Cell size}

\item{...}{Any additional specific parameters to be passed to the progressive morphological filter.
These include:\cr
- \code{exponential} logical. Default is TRUE.\cr
- \code{base} numeric. Default is 2\cr}
}
\value{
Nothing. The original LAS object is updated by reference. In the 'Classification'
column a value of 2 denotes ground according to LAS specifications.
}
\description{
Implements a Progressive Morphological Filter for segmentation of ground points.
The function updates the field \code{Classification} of the input LAS obect. The points
classified as 'ground' are assigned a value of 2 according to las specifications (See the ASPRS
documentation for the
\href{http://www.asprs.org/a/society/committees/standards/LAS_1_4_r13.pdf}{LAS file format}).
This function is an implementation of the Zhang et al. (2003) algorithm (see reference)
}
\examples{
LASfile <- system.file("extdata", "Topography.laz", package="lidR")
las = readLAS(LASfile, XYZonly = TRUE)

lasground(las, MaxWinSize = 40, Slope = 1, MaxDist = 5, InitDist = 0.01, CellSize = 7)

plot(las, color = "Classification")
}
\references{
Zhang, K., Chen, S. C., Whitman, D., Shyu, M. L., Yan, J., & Zhang, C. (2003). A progressive
morphological filter for removing nonground measurements from airborne LIDAR data. IEEE
Transactions on Geoscience and Remote Sensing, 41(4 PART I), 872–882. http:#doi.org/10.1109/TGRS.2003.810682
}
