% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/las-class.r
\docType{class}
\name{LAS-class}
\alias{LAS-class}
\title{An S4 class to represent the data read in a .las or .laz file}
\description{
A LAS object contains the data and the header read in a .las file and
additional values computed on the fly during loading.
}
\details{
A \code{LAS} object contains a \code{data.table} in the slot \code{@data} with
the data read from a \code{.las} file and other information computed during
data loading. The fields read from the las file are named:
\itemize{
\item{\code{X Y Z}}
\item{\code{Intensity}}
\item{\code{ReturnNumber}}
\item{\code{NumberOfReturns}}
\item{\code{ScanDirectionFlag}}
\item{\code{EdgeOfFlightline}}
\item{\code{Classification}}
\item{\code{ScanAngle}}
\item{\code{UserData}}
\item{\code{PointSourceID}}
}
3 other fields can be computed is desired:
slot \code{@data}:
\itemize{
\item{\code{pulseID}: a unique identifying number for each pulse so the
beam origin of each point is known (see \link[lidR:laspulse]{laspulse})}

\item{\code{flightlineID}: a unique identifying number for the flightline
so the flightline origin of each point is known (see \link[lidR:lasflightline]{lasflightline})}

\item{\code{color}: the hexadecimal name of the color of the point if R, G and B
fields exist (see \link[lidR:lascolor]{lascolor})}
}
A \code{LAS} object also contains a slot \code{@header} which contains the
header of the \code{.las} file. See the ASPRS documentation for the
\href{http://www.asprs.org/a/society/committees/standards/LAS_1_4_r13.pdf}{LAS file format}
for more information.\cr
}
\section{Slots}{

\describe{
\item{\code{data}}{data.table. a table representing the LAS data}

\item{\code{header}}{list. A list of information contained in the las file header.}
}}

\seealso{
\link[lidR:LAS]{LAS}
\link[lidR:readLAS]{readLAS}
}
