% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lastrees.r
\name{lastrees}
\alias{lastrees}
\title{Individual tree segmentation}
\usage{
lastrees(las, algorithm, ...)
}
\arguments{
\item{las}{An object of the class \code{LAS}. If missing, \code{extra} is turned to \code{TRUE}
automatically.}

\item{algorithm}{character. The name of an algorithm. Can be \code{"dalponte2016"},
\code{"watershed"},\code{"li2012"} (deprecated), \code{"li2012-2"} or \code{"silva2016"}.}

\item{...}{parameters for the algorithms. These depend on the algorithm used (see documentation
of each method).}
}
\value{
Usually nothing (NULL). The point cloud is updated by reference (in place without copy).
But some algorithms may provide extra outputs. Usually it returns intermediate objects used
internally, such as a \code{RasterLayer} or a \code{SpatialPolygonDataFrame}.
}
\description{
Individual tree segmentation with several possible algorithms. The function is a wrapper around
all the existing methods. Considering the increasing number of tree segmentation methods available,
each method is now documented on its own page (see section "See Also")
}
\examples{
LASfile <- system.file("extdata", "MixedConifer.laz", package="lidR")
las = readLAS(LASfile, select = "xyz", filter = "-drop_z_below 0")
col = pastel.colors(200)

# Li 2012
lastrees(las, "li2012-2", R = 3, speed_up = 5)
plot(las, color = "treeID", colorPalette = col)
}
\seealso{
Other tree_segmentation: \code{\link{lastrees_dalponte}},
  \code{\link{lastrees_li2}}, \code{\link{lastrees_silva}},
  \code{\link{lastrees_watershed}}
}
