% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{raster_xy_mask}
\alias{raster_xy_mask}
\title{Raster mask by union of buffers around xy positions}
\usage{
raster_xy_mask(xy, buff, r, binary = TRUE)
}
\arguments{
\item{xy}{2 columns matrix or data.frame. xy positions}

\item{buff}{vector.  buffers to apply to the xy positions}

\item{r}{raster object. target raster}

\item{binary}{boolean. should the output mask be boolean (TRUE) or greyscale 
(FALSE)}
}
\value{
a raster object
}
\description{
creates a raster mask by union of circular buffers around xy positions
}
\examples{
# create raster
r <- terra::rast(xmin=0, xmax = 40, ymin = 0, ymax = 40, resolution = 1, crs= NA )

# xy positions
xy <- data.frame(
  x = c(10, 20, 31.25, 15),
  y = c(10, 20, 31.25, 25)
)
# compute mask
mask1 <- raster_xy_mask(xy, c(5, 8, 5, 5), r)
mask2 <- raster_xy_mask(xy, c(5, 8, 5, 5), r, binary = FALSE)

# display binary raster
terra::plot(mask1)
graphics::points(xy)

# display distance raster
terra::plot(mask2)
graphics::points(xy)
}
\seealso{
\code{\link{raster_chull_mask}}
}
