% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{pointList2poly}
\alias{pointList2poly}
\title{Convert a list of points into spatial polygons object}
\usage{
pointList2poly(points_list, df = NULL, ...)
}
\arguments{
\item{points_list}{list of data frames of xy coordinates. In each data.frame 
the last row must be the same as the first row}

\item{df}{data.frame. Optional data.frame to be associated to polygons}

\item{...}{arguments to be passed to \code{\link[sf]{st_sfc}}}
}
\value{
a simple feature collection with POLYGON geometry.
}
\description{
Converts a list of points specifying polygons into a spatial object
}
\examples{
# Compute coordinates of polygons
ellipses <- ellipses4Crown(c(0, 10), c(0, 10), c(2, 2), c(3, 4), c(2.5, 3), c(2, 3),
  id = c("A", "B")
)
# Convert to sf object
ellipses1 <- pointList2poly(ellipses)
ellipses1
# Convert to sf object with user-defined data.frame
ellipses2 <- pointList2poly(ellipses, df = data.frame(info = 1:2))

# draw ellipses
plot(ellipses2, col = ellipses2$info)
}
\seealso{
\code{\link{ellipses4Crown}}
}
