% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limer_call_limer.R
\name{limer_call_limer}
\alias{limer_call_limer}
\title{Make a call to the LimeSurvey API}
\usage{
limer_call_limer(method, params = list(), ..., encoding = "utf-8")
}
\arguments{
\item{method}{API function to call. Full lis Defaults to value set in \code{options()}.}

\item{params}{Optional named list of parameters to pass to the function.}

\item{\dots}{Other arguments passed to \code{\link[httr]{POST}}.}

\item{encoding}{The encoding to use}
}
\value{
Results from the API (sometimes plain text, sometimes base64-encoded text).
}
\description{
This function makes a generic call to the LimeSurvey API.
See \url{https://manual.limesurvey.org/RemoteControl_2_API} for
API documentation.
}
\examples{
\dontrun{
limer_call_limer(method = "list_surveys")
limer_call_limer(method = "get_summary",
                 params = list(iSurveyID = 238481,
                               sStatname = "completed_responses"))
}
}
