% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseOTB.R
\name{parseOTBFunction}
\alias{parseOTBFunction}
\title{Get OTB function calls}
\usage{
parseOTBFunction(algos = NULL, gili = NULL)
}
\arguments{
\item{algos}{number of the algorithm as provided by `getOTBAlgorithm`}

\item{gili}{optional gis linkage as done by `linkOTB()`}
}
\description{
retrieve the choosen function and parses all arguments with the defaults
}
\examples{
\dontrun{
otbLinks<-link2GI::linkOTB()
if (otbLinks$exist) {

path_OTB<-otbLinks$pathOTB


## parse all modules
algo<-parseOTBAlgorithms(gili = otbLinks)


## take edge detection
otb_algorithm<-algo[27]
algo_cmd<-parseOTBFunction(algo = otb_algorithm,gili = otbLinks)
## print the current command
print(algo_cmd)
}

###########
### usecase
###########

## link to OTB
otblink<-link2GI::linkOTB()
path_OTB<-otblink$pathOTB

## get data
setwd(tempdir())
## get some typical data as provided by the authority
url<-"http://www.ldbv.bayern.de/file/zip/5619/DOP\%2040_CIR.zip"
res <- curl::curl_download(url, "testdata.zip")
unzip(res,junkpaths = TRUE,overwrite = TRUE)

## get all available OTB modules
algo<-parseOTBAlgorithms(gili = otblink)

## for the example we use the edge detection, 
## because of the windows call via a batch file 
## we have to distinguish the module name
ifelse(Sys.info()["sysname"]=="Windows", 
algo_keyword<- "EdgeExtraction.bat",
algo_keyword<- "EdgeExtraction")

# write it to a variable
otb_algorithm<-algo[algo[]==algo_keyword]
# now create the command list
algo_cmd<-parseOTBFunction(algo = otb_algorithm,gili = otblink)

## define the current run arguments
algo_cmd$input  <- file.path(getwd(),"4490600_5321400.tif")
algo_cmd$filter <- "sobel"

## create out name
outName <- paste0(getwd(),"/out",algo_cmd$filter,".tif")
algo_cmd$out <- outName

## paste full command
command <- mkOTBcmd(path_OTB,otb_algorithm,algo_cmd)

## make the system call
system(command,intern = TRUE)

##create raster
retStack<-assign(outName,raster::raster(outName))

## plot raster
raster::plot(retStack)
} 
##+##
}
