% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseOTB.R
\name{runOTB}
\alias{runOTB}
\title{Execute the OTB command list via system call}
\usage{
runOTB(
  otbCmdList = NULL,
  gili = NULL,
  retRaster = TRUE,
  retCommand = FALSE,
  quiet = TRUE
)
}
\arguments{
\item{otbCmdList}{the OTB algorithm parameter list}

\item{gili}{optional list providing the linkage to OTB as done by `linkOTB()`. If not provided the `runOTB` function try to link automatically.}

\item{retRaster}{boolean if TRUE a raster stack is returned default is FALSE}

\item{retCommand}{boolean if TRUE only the OTB API command is returned default is FALSE}

\item{quiet}{boolean  if TRUE suppressing messages default is TRUE}
}
\description{
Wrapper function which paste the OTB command list into a system call compatible string and execute this command.
}
\details{
#' Please NOTE: You must check the help to identify the correct input file argument codewort ($input_in or $input_il).
}
\examples{
\dontrun{
require(link2GI)
require(terra)
require(listviewer)

## link to OTB
otblink<-link2GI::linkOTB()

if (otblink$exist) {
 projRootDir<-tempdir()
 fn <- system.file("ex/elev.tif", package = "terra")

## for an image output example we use the Statistic Extraction, 
algoKeyword<- "LocalStatisticExtraction"

## extract the command list for the choosen algorithm 
cmd<-parseOTBFunction(algo = algoKeyword, gili = otblink)

## Please NOTE:
## You must check the help to identify the correct argument codewort ($input_in or $input_il)
listviewer::jsonedit(cmd$help)

## define the mandatory arguments all other will be default
cmd$input_in  <- fn
cmd$out <- file.path(tempdir(),"test_otb_stat.tif")
cmd$radius <- 7

## run algorithm
retStack<-runOTB(cmd,gili = otblink)

## plot image
terra::plot(retStack)

## for a data output example we use the 

algoKeyword<- "ComputeImagesStatistics"

## extract the command list for the chosen algorithm 
cmd<-parseOTBFunction(algo = algoKeyword, gili = otblink)

## get help using the convenient listviewer
listviewer::jsonedit(cmd$help)

## define the mandatory arguments all other will be default
cmd$input_il  <- file.path(tempdir(),"test.tif")
cmd$ram <- 4096
cmd$out.xml <- file.path(tempdir(),"test_otb_stat.xml")
cmd$progress <- 1

## run algorithm
ret <- runOTB(cmd,gili = otblink, quiet = F)

## as vector
print(ret)

## as xml
XML::xmlParse(cmd$out)
 
}
}
}
