% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseOTB.R
\name{parseOTBFunction}
\alias{parseOTBFunction}
\title{Retrieve the argument list from a selected OTB function}
\usage{
parseOTBFunction(algo = NULL, gili = NULL)
}
\arguments{
\item{algo}{either the number or the plain name of the `OTB` algorithm that is wanted. Note the correct (of current/selected version) information is provided by `parseOTBAlgorithms()`}

\item{gili}{optional list of available `OTB` installations, if not specified, 
`linkOTB()` is called to automatically try to find a valid OTB installation}
}
\description{
retrieve the selected function and returns a full argument list with the default settings
}
\examples{
\dontrun{
otblink<-link2GI::linkOTB()
if (otblink$exist) {

## parse all modules
algos<-parseOTBAlgorithms(gili = otblink)


## take edge detection
cmdList<-parseOTBFunction(algo = algos[27],gili = otblink)
## print the current command
print(cmdList)
}
}
##+##
}
