% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc-dendro.r
\name{ld_cc_dendro}
\alias{ld_cc_dendro}
\title{Show the list of Computational Components as a Dendrogram}
\usage{
ld_cc_dendro(x)
}
\arguments{
\item{x}{a named list of computational components}
}
\description{
This function creates text dendrograms from
a list of computational components. It is useful for
creating a dendrogram of the the computational components of a listdown
object allowing the user to view the components hierarchically.
}
\examples{
if (require("ggplot2")) {

  cc_list <- list(
    Linear = ggplot(anscombe, aes(x = x1, y = y1)) + geom_point(),
   `Non Linear` = ggplot(anscombe, aes(x = x2, y = y2)) + geom_point(),
   `Outlier Vertical`= ggplot(anscombe, aes(x = x3, y = y3)) + geom_point(),
   `Outlier Horizontal` =  ggplot(anscombe, aes(x = x4, y = y4)) +
     geom_point())

  ld_cc_dendro(cc_list)
}
}
