% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_walk_forc.R
\name{random_walk_forc}
\alias{random_walk_forc}
\title{Random walk forecast}
\usage{
random_walk_forc(realized_vec, h_ahead, time_vec = NULL)
}
\arguments{
\item{realized_vec}{Vector of realized values. This is the series that is
being forecasted.}

\item{h_ahead}{Integer representing the number of periods ahead that is being
forecasted.}

\item{time_vec}{Vector of any class that is equal in length to the
\code{realized_vec} vector.}
}
\value{
\code{\link{Forecast}} object that contains the random walk forecast.
}
\description{
\code{random_walk_forc} takes a vector of realized values, an integer
number of periods ahead to forecast, and an optional vector of time data
associated with the realized values. In each period, the current period value
of the \code{realized_vec} series is set as the \code{h_ahead} period ahead forecast.
Returns a random walk forecast where the \code{h_ahead} period ahead forecast
is simply the present value of the series being forecasted.
}
\examples{
date <- as.Date(c("2010-03-31", "2010-06-30", "2010-09-30", "2010-12-31",
                  "2011-03-31", "2011-06-30", "2011-09-30", "2011-12-31", 
                  "2012-03-31", "2012-06-30"))
y  <- c(1.09, 1.71, 1.09, 2.46, 1.78, 1.35, 2.89, 2.11, 2.97, 0.99)
data <- data.frame(date, y)

random_walk_forc(
  realized_vec = data$y,
  h_ahead = 4L,
  time_vec = data$date 
)

}
\seealso{
For a detailed example see the help vignette:
\code{vignette("lmForc", package = "lmForc")}
}
