% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmQCM.R
\name{lmQCM}
\alias{lmQCM}
\title{lmQCM: Main Routine for Gene Co-expression Analysis}
\usage{
lmQCM(data_in, gamma = 0.55, t = 1, lambda = 1, beta = 0.4,
  minClusterSize = 10, CCmethod = "pearson")
}
\arguments{
\item{data_in}{real-valued expression matrix with rownames indicating gene ID or gene symbol}

\item{gamma}{gamma value (default = 0.55)}

\item{t}{t value (default = 1)}

\item{lambda}{lambda value (default = 1)}

\item{beta}{beta value (default = 0.4)}

\item{minClusterSize}{minimum length of cluster to retain (default = 10)}

\item{CCmethod}{Methods for correlation coefficient calculation (default = "pearson"). Users can also pick "spearman".}
}
\value{
mergedCluster - An merged clusters group
}
\description{
Author: Zhi Huang
}
\examples{
library(lmQCM)
library(Biobase)
data(sample.ExpressionSet)
data = assayData(sample.ExpressionSet)$exprs
lmQCM(data)

}
