% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localStrat.r
\name{powerMethod}
\alias{powerMethod}
\title{Cpp implementation of the power method (von Mises iteration) to compute the largest eigenvector for a (sparse) input matrix.}
\usage{
powerMethod(m, initvector = 0)
}
\arguments{
\item{m}{Symmetric matrix for which the largest eigenvector is sought.}

\item{initvector}{Optional vector compatible with the input matrix which serves as a starting value for the iteration. Default is zero.}
}
\value{
The largest eigenvector of \code{m}.
}
\description{
Cpp implementation of the power method (von Mises iteration) to compute the largest eigenvector for a (sparse) input matrix.
}
\examples{
library(locStra)
m <- matrix(1:9,3)
print(powerMethod(m))

}
\references{
Richard von Mises and Hilda Pollaczek-Geiringer (1929). Praktische Verfahren der Gleichungsaufloesung. ZAMM Zeitschrift fuer Angewandte Mathematik und Mechanik, 9:152-164.
}
