% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMethods.R
\name{monteCarlo_double}
\alias{monteCarlo_double}
\title{Monte Carlo method for real score case [p-value]}
\usage{
monteCarlo_double(local_score, FUN, ..., plot = TRUE, numSim = 1000)
}
\arguments{
\item{local_score}{local score observed in a segment.}

\item{FUN}{function to simulate similar sequences with.}

\item{...}{parameters for FUN}

\item{plot}{Boolean value if to display plots for cumulated function and density}

\item{numSim}{number of sequences to generate during simulation}
}
\value{
Floating value corresponding to the probability to obtain a local score with value greater or equal to the parameter
}
\description{
Calculates an empirical p-value based on simulations of similar sequences of the same length.
Perfect for small sequences (both markov chains and identically and independantly distributed) with length ~ 10^3. Function dedicated for real score case.
}
\examples{

score_reels=c(-1,-0.5,0,0.5,1)
proba_score_reels=c(0.2,0.3,0.1,0.2,0.2)
sample_from_model <- function(score.sple,proba.sple, length.sple){sample(score.sple,
                                  size=length.sple, prob=proba.sple, replace=TRUE)}
\donttest{
monteCarlo_double(5.5,FUN=sample_from_model, plot = TRUE, 
score.sple=score_reels,proba.sple=proba_score_reels, length.sple=100, numSim = 1000)
}
}
