% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{exact_mc}
\alias{exact_mc}
\title{Exact method for p-value [Markov chains]}
\usage{
exact_mc(m, localScore, sequence_length, sequence_min, sequence_max)
}
\arguments{
\item{m}{Transition matrix [matrix object]}

\item{localScore}{score for which the p-value should be calculated}

\item{sequence_length}{length of the sequence}

\item{sequence_min}{minimum score}

\item{sequence_max}{maximum score}
}
\value{
A double representing the probability of a localScore as high as the one given as argument
}
\description{
Calculates the exact p-value for short numerical Markov chains. Time computation can be too large for a sequence length of several thousands, specially for a data set.
}
\examples{
matrix = t(matrix(c(0.2, 0.3, 0.5, 0.3, 0.4, 0.3, 0.2, 0.4, 0.4), nrow = 3))
exact_mc(localScore = 12, m = matrix, sequence_length = 100, sequence_min = -1, sequence_max = 1)
exact_mc(localScore = 150, m = matrix, sequence_length = 1000, sequence_min = -1, sequence_max = 1)
}
