% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.logger.R
\name{logger}
\alias{logger}
\title{Create Logger Objects}
\usage{
logger(threshold = "INFO", appenders = console_appender())
}
\arguments{
\item{threshold}{The logging threshold level. Messages with a lower priority
level will be discarded. See \code{\link{loglevel}}.}

\item{appenders}{The logging appenders; both single appenders and a
\code{list()} of them are supported. See \code{\link{appenders}}.}
}
\value{
An object of class \code{"logger"}.
}
\description{
This is the main interface for configuring logging behaviour. We adopt the
well-known \href{https://logging.apache.org/log4j/}{log4j} etymology:
\strong{\link[=appenders]{Appenders}} are destinations (e.g. the console or
a file) where messages are written, and the \strong{\link[=layouts]{Layout}}
is the format of the messages.
}
\examples{
# By default, messages are logged to the console at the
# "INFO" threshold.
logger <- logger()

info(logger, "Located nearest gas station.")
warn(logger, "Ez-Gas sensor network is not available.")
debug(logger, "Debug messages are suppressed by default.")

}
\seealso{
\strong{\link[=appenders]{Appenders}} and \strong{\link[=layouts]{Layouts}}
for information on controlling the behaviour of the logger object.
}
