% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loggit.R
\name{get_logs}
\alias{get_logs}
\title{Return Log File as an R Object}
\usage{
get_logs(logfile, as_df = TRUE)
}
\arguments{
\item{logfile}{JSON-format log file to return.}

\item{as_df}{Should logfile be returned in a \code{data.frame} vs. a \code{list}?
Defaults to \code{TRUE}, and will return a \code{data.frame}.}
}
\value{
A \code{data.frame}.
}
\description{
This function returns a \code{data.frame} (by default) containing all the logs in
the provided JSON log file. If no explicit log fie is provided, calling this
function will return a data frame of the log file currently pointed to by the
loggit functions. Users can request that the logs be returned as a \code{list},
though this is not recommended.
}
\examples{
setLogFile(file.path(tempdir(), "loggit.json"), confirm = FALSE)
message("Test log message")
get_logs(getLogFile())

}
