% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/logisticPCA.R
\name{predict.lpca}
\alias{predict.lpca}
\title{Predict Logistic PCA scores or reconstruction on new data}
\usage{
\method{predict}{lpca}(object, newdata, type = c("PCs", "link", "response"),
  ...)
}
\arguments{
\item{object}{logistic PCA object}

\item{newdata}{matrix with all binary entries. If missing, will use the
data that \code{object} was fit on}

\item{type}{the type of fitting required. \code{type = "PCs"} gives the PC scores,
\code{type = "link"} gives matrix on the logit scale and \code{type = "response"}
gives matrix on the probability scale}

\item{...}{Additional arguments}
}
\description{
Predict Logistic PCA scores or reconstruction on new data
}
\examples{
# construct a low rank matrices in the logit scale
rows = 100
cols = 10
set.seed(1)
loadings = rnorm(cols)
mat_logit = outer(rnorm(rows), loadings)
mat_logit_new = outer(rnorm(rows), loadings)

# convert to a binary matrix
mat = (matrix(runif(rows * cols), rows, cols) <= inv.logit.mat(mat_logit)) * 1.0
mat_new = (matrix(runif(rows * cols), rows, cols) <= inv.logit.mat(mat_logit_new)) * 1.0

# run logistic PCA on it
lpca = logisticPCA(mat, k = 1, M = 4, main_effects = FALSE)

PCs = predict(lpca, mat_new)
}

