% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_ggplot.R
\name{l_ggplot}
\alias{l_ggplot}
\title{Automatically create a loon widget}
\usage{
l_ggplot(data = NULL, mapping = aes(), ..., environment = parent.frame())
}
\arguments{
\item{data}{Default dataset to use for plot. If not already a data.frame, will be converted to one by fortify().
If not specified, must be supplied in each layer added to the plot.}

\item{mapping}{Default list of aesthetic mappings to use for plot.
If not specified, must be supplied in each layer added to the plot.}

\item{...}{Other arguments passed on to methods. Not currently used.}

\item{environment}{DEPRECATED. Used prior to tidy evaluation.}
}
\value{
It will return an \code{l_ggplot} object with class \code{c("l_ggplot", "gg", "ggplot")}.
Then print a \code{loon} plot automatically.
}
\description{
Create a \code{loon} widget with \code{ggplot} syntax
}
\details{
function \code{l_ggplot()} wraps function \code{ggplot()} with assigning an additional class "l_ggplot"
to the output. The returned object is called an \code{l_ggplot} object.
To draw a \code{ggplot} object, S3 method \code{print.ggplot} will be rendered
so that a static graphic is displayed. While, for an \code{l_ggplot()} object,
S3 method \code{print.l_ggplot} will be rendered
which will return an interactive \code{loon} widget.
}
\examples{
if(interactive()) {
p <- l_ggplot(mpg, aes(displ, cty)) +
    geom_point(
      size = 4,
      mapping = aes(color = factor(cyl))
    )
# p is an `l_ggplot` object, `print.l_ggplot(p)` will be called automatically.
# Then, at printing time, an `l_ggplot` object will be transformed to a `loon` widget
p

\dontrun{
# Assign a widget from current path
# suppose the path of `p` is '.l0.ggplot'
q <- l_getFromPath('.l0.ggplot')
# q is a `loon` widget
q
}

# An alternative way to return a real loon widget from `p` (a `l_ggplot` object)
# is to call the function `loon.ggplot`. Compared with calling function `l_getFrompath`
# this way can provide richer information (note that it will create a new widget).
q <- loon.ggplot(p)
q

# pipe more components
p +
  facet_grid(rows = vars(drv)) +
  linking(linkingGroup = "mpg") +
  ggtitle("displ versus cty")
# a linked bar plot
l_hist(mpg$class, linkingGroup = "mpg")

# a 3D object
# press the button key `R` to rotate the plot
l_ggplot(mtcars,
         mapping = aes(x = wt, y = hp, z = drat)) +
   geom_point(size = 4)
}
}
\seealso{
\code{\link{ggplot}}, \code{\link{ggplot2loon}}, \code{\link{print.l_ggplot}}

\code{\link{loon.ggplot}}
}
