% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpcde_methods.R
\name{confint.lpcde}
\alias{confint.lpcde}
\title{Confint method for local polynomial density conditional estimation}
\usage{
\method{confint}{lpcde}(
  object,
  parm = NULL,
  level = NULL,
  CIuniform = FALSE,
  CIsimul = 2000,
  alpha = 0.05,
  ...
)
}
\arguments{
\item{object}{Class "lpdensity" object, obtained by calling \code{\link{lpcde}}.}

\item{parm}{Integer, indicating which parameters are to be given confidence intervals.}

\item{level}{Numeric scalar between 0 and 1, the significance level for computing
confidence intervals}

\item{CIuniform}{\code{TRUE} or \code{FALSE} (default), plotting either pointwise confidence intervals (\code{FALSE}) or
uniform confidence bands (\code{TRUE}).}

\item{CIsimul}{Positive integer, specifies the number of simulations used to construct critical values (default is \code{2000}). This
option is ignored if \code{CIuniform=FALSE}.}

\item{alpha}{Numeric scalar between 0 and 1, specifies the significance level for plotting
confidence intervals/bands.}

\item{...}{Additional options, including (i) \code{grid} specifies a subset of grid points
to display the bandwidth; (ii) \code{gridIndex} specifies the indices of grid points
to display the bandwidth (this is the same as \code{parm});(iii)
\code{CIuniform} specifies whether displaying pointwise confidence intervals
(\code{FALSE}, default) or
the uniform confidence band (\code{TRUE}); (iv) \code{CIsimul} specifies the number of
simulations used to construct critical values (default is 2000).}
}
\value{
\item{Estimate}{A matrix containing grid points, estimates and confidence interval end points using p- and q-th order local polynomials
as well as bias-corrected estimates and corresponding confidence intervals.}
\item{crit_val}{The critical value used in computing the confidence interval end points.}
}
\description{
The confint method for local polynomial conditional density objects.
}
\examples{
n=100
x_data = as.matrix(rnorm(n, mean=0, sd=1))
y_data = as.matrix(rnorm(n, mean=0, sd=1))
y_grid = stats::quantile(y_data, seq(from=0.1, to=0.9, by=0.1))
# density estimation
model1 = lpcde::lpcde(x_data=x_data, y_data=y_data, y_grid=y_grid, x=0, bw=0.5)
confint(model1)

}
\seealso{
\code{\link{lpcde}} for local polynomial conditional density estimation.

Supported methods: \code{\link{coef.lpcde}}, \code{\link{confint.lpcde}},
\code{\link{plot.lpcde}}, \code{\link{print.lpcde}},
\code{\link{summary.lpcde}}, \code{\link{vcov.lpcde}}
}
\author{
Matias D. Cattaneo, Princeton University. \email{cattaneo@princeton.edu}.

Rajita Chandak (maintainer), Princeton University. \email{rchandak@princeton.edu}.

Michael Jansson, University of California Berkeley. \email{mjansson@econ.berkeley.edu}.

Xinwei Ma, University of California San Diego. \email{x1ma@ucsd.edu}.
}
