% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence_intervals_pjk.R
\name{confidence_intervals_pjk}
\alias{confidence_intervals_pjk}
\title{Confidence Intervals for lphom estimates}
\usage{
confidence_intervals_pjk(lphom.object, level = 0.9, num.d = 11, B = 30)
}
\arguments{
\item{lphom.object}{An object output of the \strong{lphom()} function.}

\item{level}{A number between 0 and 1 to be used as level of confidence for the intervals. By default 0.90}

\item{num.d}{Number maximum of different disturbances, \code{d}, to be initially considered. Positive integer greater than or equal to 5. By default, 11.}

\item{B}{Integer that determines the number of simulations to be performed for each disturbance value. By default, 30.}
}
\value{
A list with the following components
\item{TM.estimation}{ Transfer matrix of probability point estimates.}
\item{TM.lower}{ Transfer matrix of lower values for the probability estimates.}
\item{TM.upper}{ Transfer matrix of upper values for the probability estimates.}
\item{level}{ Confidence level used when computing the confidence intervals.}
}
\description{
Estimates confidence intervals for the (vote) transfer probabilities obtained with \strong{lphom()}
}
\examples{
mt.lphom <- lphom(France2017P[, 1:8], France2017P[, 9:12], "raw", NULL, FALSE)
set.seed(533423)
confidence_intervals_pjk(mt.lphom, level = 0.90, num.d = 5, B = 8)
}
\references{
Romero, R, Pavia, JM, Martin, J and Romero G (2020). Assessing uncertainty of voter transitions estimated from aggregated data. Application to the 2017 French presidential election. \emph{Journal of Applied Statistics}, 47(13-15), 2711-2736. \doi{10.1080/02664763.2020.1804842}

Martin, J (2020). Analisis de la incertidumbre en la estimacion de la movilidad electoral mediante el procedimiento plhom. PhD Dissertation.
}
\seealso{
\code{\link{lphom}} \code{\link{error_lphom}}
}
\author{
Jose M. Pavia, \email{pavia@uv.es}

Rafael Romero \email{rromero@eio.upv.es}
}
