% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDesignMeans.R
\name{getDesignRepeatedANOVA}
\alias{getDesignRepeatedANOVA}
\title{Power and Sample Size for Repeated-Measures ANOVA}
\usage{
getDesignRepeatedANOVA(
  beta = NA_real_,
  n = NA_real_,
  ngroups = 2,
  means = NA_real_,
  stDev = 1,
  corr = 0,
  rounding = TRUE,
  alpha = 0.05
)
}
\arguments{
\item{beta}{The type II error.}

\item{n}{The total sample size.}

\item{ngroups}{The number of treatment groups.}

\item{means}{The treatment group means.}

\item{stDev}{The total standard deviation.}

\item{corr}{The correlation among the repeated measures.}

\item{rounding}{Whether to round up sample size. Defaults to 1 for
sample size rounding.}

\item{alpha}{The two-sided significance level. Defaults to 0.05.}
}
\value{
An S3 class \code{designRepeatedANOVA} object with the
following components:
\itemize{
\item \code{power}: The power to reject the null hypothesis that
there is no difference among the treatment groups.
\item \code{alpha}: The two-sided significance level.
\item \code{n}: The number of subjects.
\item \code{ngroups}: The number of treatment groups.
\item \code{means}: The treatment group means.
\item \code{stDev}: The total standard deviation.
\item \code{corr}: The correlation among the repeated measures.
\item \code{effectsize}: The effect size.
\item \code{rounding}: Whether to round up sample size.
}
}
\description{
Obtains the power and sample size for one-way repeated
measures analysis of variance. Each subject takes all treatments
in the longitudinal study.
}
\details{
Let \eqn{y_{ij}} denote the measurement under treatment condition
\eqn{j (j=1,\ldots,k)} for subject \eqn{i (i=1,\ldots,n)}. Then
\deqn{y_{ij} = \alpha + \beta_j + b_i + e_{ij},} where \eqn{b_i}
denotes the subject random effect, \eqn{b_i \sim N(0, \sigma_b^2),}
and \eqn{e_{ij} \sim N(0, \sigma_e^2)} denotes the within-subject
residual. If we set \eqn{\beta_k = 0}, then \eqn{\alpha} is the
mean of the last treatment (control), and \eqn{\beta_j} is the
difference in means between the \eqn{j}th treatment and the control
for \eqn{j=1,\ldots,k-1}.

The repeated measures have a compound symmetry covariance structure.
Let \eqn{\sigma^2 = \sigma_b^2 + \sigma_e^2}, and
\eqn{\rho = \frac{\sigma_b^2}{\sigma_b^2 + \sigma_e^2}}. Then
\eqn{Var(y_i) = \sigma^2 \{(1-\rho) I_k + \rho 1_k 1_k^T\}}.
Let \eqn{X_i} denote the design matrix for subject \eqn{i}.
Let \eqn{\theta = (\alpha, \beta_1, \ldots, \beta_{k-1})^T}.
It follows that
\deqn{Var(\hat{\theta}) = \left(\sum_{i=1}^{n} X_i^T V_i^{-1}
X_i\right)^{-1}.} It can be shown that
\deqn{Var(\hat{\beta}) = \frac{\sigma^2 (1-\rho)}{n} (I_{k-1} +
1_{k-1} 1_{k-1}^T).} It follows that
\eqn{\hat{\beta}^T \hat{V}_{\hat{\beta}}^{-1} \hat{\beta} \sim
F_{k-1,(n-1)(k-1), \lambda},} where the noncentrality parameter for
the \eqn{F} distribution is \deqn{\lambda =
\beta^T V_{\hat{\beta}}^{-1} \beta = \frac{n \sum_{j=1}^{k}
(\mu_j - \bar{\mu})^2}{\sigma^2(1-\rho)}.}
}
\examples{

(design1 <- getDesignRepeatedANOVA(
  beta = 0.1, ngroups = 4, means = c(1.5, 2.5, 2, 0),
  stDev = 5, corr = 0.2, alpha = 0.05))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
