% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lrsamplesizeequiv}
\alias{lrsamplesizeequiv}
\title{Sample size for equivalence in hazard ratio}
\usage{
lrsamplesizeequiv(
  beta = 0.2,
  kMax = 1L,
  informationRates = NA_real_,
  criticalValues = NA_real_,
  alpha = 0.05,
  typeAlphaSpending = "sfOF",
  parameterAlphaSpending = NA_real_,
  userAlphaSpending = NA_real_,
  hazardRatioLower = NA_real_,
  hazardRatioUpper = NA_real_,
  allocationRatioPlanned = 1,
  accrualTime = 0L,
  accrualIntensity = NA_real_,
  piecewiseSurvivalTime = 0L,
  stratumFraction = 1L,
  lambda1 = NA_real_,
  lambda2 = NA_real_,
  gamma1 = 0L,
  gamma2 = 0L,
  accrualDuration = NA_real_,
  followupTime = NA_real_,
  fixedFollowup = 0L,
  typeOfComputation = "direct",
  interval = as.numeric(c(0.001, 240)),
  spendingTime = NA_real_,
  rounding = 1L
)
}
\arguments{
\item{beta}{The type II error.}

\item{kMax}{The maximum number of stages.}

\item{informationRates}{The information rates.
Defaults to \code{(1:kMax) / kMax} if left unspecified.}

\item{criticalValues}{Upper boundaries on the z-test statistic scale
for stopping for efficacy.}

\item{alpha}{The significance level for each of the two one-sided
tests. Defaults to 0.05.}

\item{typeAlphaSpending}{The type of alpha spending. One of the following:
"OF" for O'Brien-Fleming boundaries, "P" for Pocock boundaries,
"WT" for Wang & Tsiatis boundaries, "sfOF" for O'Brien-Fleming type
spending function, "sfP" for Pocock type spending function,
"sfKD" for Kim & DeMets spending function, "sfHSD" for Hwang,
Shi & DeCani spending function, "user" for user defined spending,
and "none" for no early efficacy stopping. Defaults to "sfOF".}

\item{parameterAlphaSpending}{The parameter value for the alpha spending.
Corresponds to Delta for "WT", rho for "sfKD", and gamma for "sfHSD".}

\item{userAlphaSpending}{The user defined alpha spending. Cumulative alpha
spent up to each stage.}

\item{hazardRatioLower}{The lower equivalence limit of hazard ratio.}

\item{hazardRatioUpper}{The upper equivalence limit of hazard ratio.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{accrualTime}{A vector that specifies the starting time of
piecewise Poisson enrollment time intervals. Must start with 0, e.g.,
\code{c(0, 3)} breaks the time axis into 2 accrual intervals:
[0, 3) and [3, Inf).}

\item{accrualIntensity}{A vector of accrual intensities. One for
each accrual time interval.}

\item{piecewiseSurvivalTime}{A vector that specifies the starting time of
piecewise exponential survival time intervals. Must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{stratumFraction}{A vector of stratum fractions that sum to 1.
Defaults to 1 for no stratification.}

\item{lambda1}{A vector of hazard rates for the event in each analysis
time interval by stratum for the active treatment group.}

\item{lambda2}{A vector of hazard rates for the event in each analysis
time interval by stratum for the control group.}

\item{gamma1}{The hazard rate for exponential dropout, a vector of hazard
rates for piecewise exponential dropout applicable for all strata, or a
vector of hazard rates for dropout in each analysis time interval
by stratum for the active treatment group.}

\item{gamma2}{The hazard rate for exponential dropout, a vector of hazard
rates for piecewise exponential dropout applicable for all strata, or a
vector of hazard rates for dropout in each analysis time interval
by stratum for the control group.}

\item{accrualDuration}{Duration of the enrollment period.}

\item{followupTime}{Follow-up time for the last enrolled subject.}

\item{fixedFollowup}{Whether a fixed follow-up design is used.
Defaults to 0 for variable follow-up.}

\item{typeOfComputation}{The type of computation,
either "direct" for the direct approximation method,
or "schoenfeld" for the Schoenfeld method.
Defaults to "direct". Can use "Schoenfeld"
under proportional hazards and conventional log-rank test.}

\item{interval}{The interval to search for the solution of
accrualDuration, followupDuration, or the proportionality constant
of accrualIntensity. Defaults to \code{c(0.001, 240)}.}

\item{spendingTime}{A vector of length \code{kMax} for the error spending
time at each analysis. Defaults to missing, in which case, it is the
same as \code{informationRates}.}

\item{rounding}{Whether to round up sample size.
Defaults to 1 for sample size rounding.}
}
\value{
An S3 class \code{lrpowerequiv} object
}
\description{
Obtains the sample size for equivalence in hazard ratio.
}
\examples{

lrsamplesizeequiv(kMax = 2, informationRates = c(0.5, 1),
                  alpha = 0.05, typeAlphaSpending = "sfOF",
                  hazardRatioLower = 0.71, hazardRatioUpper = 1.4,
                  allocationRatioPlanned = 1, accrualTime = seq(0, 8),
                  accrualIntensity = 26/9*seq(1, 9),
                  piecewiseSurvivalTime = c(0, 6),
                  stratumFraction = c(0.2, 0.8),
                  lambda1 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
                  lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
                  gamma1 = -log(1-0.05)/12,
                  gamma2 = -log(1-0.05)/12, accrualDuration = NA,
                  followupTime = 18, fixedFollowup = FALSE)

}
\seealso{
\code{\link{lrpowerequiv}}
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
