% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rmpower1s}
\alias{rmpower1s}
\title{Power for one-sample restricted mean survival time}
\usage{
rmpower1s(
  kMax = 1L,
  informationRates = NA_real_,
  efficacyStopping = NA_integer_,
  futilityStopping = NA_integer_,
  criticalValues = NA_real_,
  alpha = 0.025,
  typeAlphaSpending = "sfOF",
  parameterAlphaSpending = NA_real_,
  userAlphaSpending = NA_real_,
  futilityBounds = NA_real_,
  typeBetaSpending = "none",
  parameterBetaSpending = NA_real_,
  milestone = NA_real_,
  rmstH0 = NA_real_,
  accrualTime = 0L,
  accrualIntensity = NA_real_,
  piecewiseSurvivalTime = 0L,
  stratumFraction = 1L,
  lambda = NA_real_,
  gamma = 0L,
  accrualDuration = NA_real_,
  followupTime = NA_real_,
  fixedFollowup = 0L,
  spendingTime = NA_real_,
  studyDuration = NA_real_
)
}
\arguments{
\item{kMax}{The maximum number of stages.}

\item{informationRates}{The information rates.
Defaults to \code{(1:kMax) / kMax} if left unspecified.}

\item{efficacyStopping}{Indicators of whether efficacy stopping is allowed
at each stage. Defaults to true if left unspecified.}

\item{futilityStopping}{Indicators of whether futility stopping is allowed
at each stage. Defaults to true if left unspecified.}

\item{criticalValues}{Upper boundaries on the z-test statistic scale
for stopping for efficacy.}

\item{alpha}{The significance level. Defaults to 0.025.}

\item{typeAlphaSpending}{The type of alpha spending. One of the following:
"OF" for O'Brien-Fleming boundaries, "P" for Pocock boundaries,
"WT" for Wang & Tsiatis boundaries, "sfOF" for O'Brien-Fleming type
spending function, "sfP" for Pocock type spending function,
"sfKD" for Kim & DeMets spending function, "sfHSD" for Hwang,
Shi & DeCani spending function, "user" for user defined spending,
and "none" for no early efficacy stopping. Defaults to "sfOF".}

\item{parameterAlphaSpending}{The parameter value for the alpha spending.
Corresponds to Delta for "WT", rho for "sfKD", and gamma for "sfHSD".}

\item{userAlphaSpending}{The user defined alpha spending. Cumulative alpha
spent up to each stage.}

\item{futilityBounds}{Lower boundaries on the z-test statistic scale
for stopping for futility at stages 1, ..., \code{kMax-1}. Defaults to
\code{rep(-6, kMax-1)} if left unspecified. The futility bounds are
non-binding for the calculation of critical values.}

\item{typeBetaSpending}{The type of beta spending. One of the following:
"sfOF" for O'Brien-Fleming type spending function, "sfP" for Pocock
type spending function, "sfKD" for Kim & DeMets spending function,
"sfHSD" for Hwang, Shi & DeCani spending function, and "none" for no
early futility stopping. Defaults to "none".}

\item{parameterBetaSpending}{The parameter value for the beta spending.
Corresponds to rho for "sfKD", and gamma for "sfHSD".}

\item{milestone}{The milestone time at which to calculate the
restricted mean survival time.}

\item{rmstH0}{The restricted mean survival time under the null
hypothesis.}

\item{accrualTime}{A vector that specifies the starting time of
piecewise Poisson enrollment time intervals. Must start with 0, e.g.,
\code{c(0, 3)} breaks the time axis into 2 accrual intervals:
[0, 3) and [3, Inf).}

\item{accrualIntensity}{A vector of accrual intensities. One for
each accrual time interval.}

\item{piecewiseSurvivalTime}{A vector that specifies the starting time of
piecewise exponential survival time intervals. Must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{stratumFraction}{A vector of stratum fractions that sum to 1.
Defaults to 1 for no stratification.}

\item{lambda}{A vector of hazard rates for the event in each analysis
time interval by stratum under the alternative hypothesis.}

\item{gamma}{The hazard rate for exponential dropout or a vector of
hazard rates for piecewise exponential dropout. Defaults to 0 for
no dropout.}

\item{accrualDuration}{Duration of the enrollment period.}

\item{followupTime}{Follow-up time for the last enrolled subject.}

\item{fixedFollowup}{Whether a fixed follow-up design is used.
Defaults to 0 for variable follow-up.}

\item{spendingTime}{A vector of length \code{kMax} for the error spending
time at each analysis. Defaults to missing, in which case, it is the
same as \code{informationRates}.}

\item{studyDuration}{Study duration for fixed follow-up design.
Defaults to missing, which is to be replaced with the sum of
\code{accrualDuration} and \code{followupTime}. If provided,
the value is allowed to be less than the sum of \code{accrualDuration}
and \code{followupTime}.}
}
\value{
An S3 class \code{rmpower1s} object with 3 components:
\itemize{
\item \code{overallResults}: A data frame containing the following variables:
\itemize{
\item \code{overallReject}: The overall rejection probability.
\item \code{alpha}: The overall significance level.
\item \code{drift}: The drift parameter, equal to
\code{(rmst - rmstH0)*sqrt(information)}.
\item \code{inflationFactor}: The inflation factor (relative to the
fixed design).
\item \code{numbeOfSubjects}: The total number of subjects.
\item \code{studyDuration}: The total study duration.
\item \code{information}: The maximum information.
\item \code{expectedNumberOfSubjects}: The expected number of subjects.
\item \code{expectedStudyDuration}: The expected study duration.
\item \code{expectedInformation}: The expected information.
\item \code{accrualDuration}: The accrual duration.
\item \code{followupTime}: The follow-up duration.
\item \code{fixedFollowup}: Whether a fixed follow-up design is used.
\item \code{kMax}: The number of stages.
\item \code{milestone}: The milestone time relative to randomization.
\item \code{rmstH0}: The restricted mean survival time under the null
hypothesis.
\item \code{rmst}: The restricted mean survival time under the
alternative hypothesis.
}
\item \code{byStageResults}: A data frame containing the following variables:
\itemize{
\item \code{informationRates}: The information rates.
\item \code{efficacyBounds}: The efficacy boundaries on the Z-scale.
\item \code{futilityBounds}: The futility boundaries on the Z-scale.
\item \code{rejectPerStage}: The probability for efficacy stopping.
\item \code{futilityPerStage}: The probability for futility stopping.
\item \code{cumulativeRejection}: The cumulative probability for efficacy
stopping.
\item \code{cumulativeFutility}: The cumulative probability for futility
stopping.
\item \code{cumulativeAlphaSpent}: The cumulative alpha spent.
\item \code{numberOfSubjects}: The number of subjects.
\item \code{analysisTime}: The average time since trial start.
\item \code{efficacyRmst}: The efficacy boundaries on the restricted
mean survival time.
\item \code{futilityRmst}: The futility boundaries on the restricted
mean survival time.
\item \code{efficacyP}: The efficacy boundaries on the p-value scale.
\item \code{futilityP}: The futility boundaries on the p-value scale.
\item \code{information}: The cumulative information.
\item \code{efficacyStopping}: Whether to allow efficacy stopping.
\item \code{futilityStopping}: Whether to allow futility stopping.
}
\item \code{settings}: A list containing the following input parameters:
\code{typeAlphaSpending}, \code{parameterAlphaSpending},
\code{userAlphaSpending}, \code{typeBetaSpending},
\code{parameterBetaSpending}, \code{accrualTime},
\code{accuralIntensity}, \code{piecewiseSurvivalTime},
\code{stratumFraction}, \code{lambda}, \code{gamma},
and \code{spendingTime}.
}
}
\description{
Estimates the power, stopping probabilities, and expected
sample size in a one-group survival design.
}
\examples{

rmpower1s(kMax = 2, informationRates = c(0.8, 1),
          alpha = 0.025, typeAlphaSpending = "sfOF",
          milestone = 18, rmstH0 = 10,
          accrualTime = seq(0, 8),
          accrualIntensity = 26/9*seq(1, 9),
          piecewiseSurvivalTime = c(0, 6),
          stratumFraction = c(0.2, 0.8),
          lambda = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
          gamma = -log(1-0.05)/12, accrualDuration = 22,
          followupTime = 18, fixedFollowup = FALSE)

}
\seealso{
\code{\link{rmstat}}
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
