% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weight_responses.R
\name{weight_responses}
\alias{weight_responses}
\title{Weight responses}
\usage{
weight_responses(
  cluster_bg,
  n_obs,
  N,
  lvl,
  sublvl,
  previous_sublvl,
  sampling_method,
  cluster_labels,
  resp_labels,
  sum_pop,
  verbose
)
}
\arguments{
\item{cluster_bg}{dataset with background questionnaire}

\item{n_obs}{list with the number of elements per level}

\item{N}{list of numeric vector with the population size of each *sampled* cluster element on each level}

\item{lvl}{number of the current level}

\item{sublvl}{number of the current sub-level (element within level)}

\item{previous_sublvl}{number of the sub-level of the parent level}

\item{sampling_method}{can be "SRS" for Simple Random Sampling or "PPS" for Probabilities Proportional to Size}

\item{cluster_labels}{character vector with the names of each cluster level}

\item{resp_labels}{character vector with the names of the questionnaire respondents on each level}

\item{sum_pop}{total population at each level (sampled or not)}

\item{verbose}{if `TRUE`, prints output messages}
}
\value{
Input data frame (`cluster_bg`) with three new columns for the sampling weights.
}
\description{
calculates sampling weights for the questionnaire responses
}
