% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfsim.lsbclust.R
\name{cfsim.lsbclust}
\alias{cfsim.lsbclust}
\title{Compare LSBCLUST Simulation Results}
\usage{
\method{cfsim}{lsbclust}(fitted, actual, method = c("diag", "cRand"))
}
\arguments{
\item{fitted}{An object of class \code{lsbclust} containing the fitted results.}

\item{actual}{An object of class \code{lsbclust_sim} containing the simulated data.}

\item{method}{The type of statistics to calculate, passed to \code{\link{cl_agreement}}}
}
\description{
This function compares cluster membership and parameter estimates for the results of
\code{\link{lsbclust}} on simulated data to the true underlying values.
}
\examples{
## Simulate LSBCLUST data, fit LSBCLUST, and compare
set.seed(1)
dat <- rlsbclust(ndata = 1, nobs = 100, size = c(10, 8), nclust = c(5, 4, 6, 5))
res <- lsbclust(data = dat[[1]]$data, nclust = c(5, 4, 6, 5))
cfsim(res, dat[[1]])
}
