# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @rdname ClustMeans
#' @title C++ Function for Cluster Means
#' @name ClustMeans
#' @description This function calculates the cluster means in vectorized form based on the current
#' value of the clustering vector.
#' @param nclust The number of clusters.
#' @param start The current clustering vector.
#' @param data The concatenated data, with J * K rows and N columns
#' @return A numeric matrix with \code{nclust} rows and \code{J*K} columns.
ClustMeans <- function(nclust, start, data) {
    .Call('lsbclust_ClustMeans', PACKAGE = 'lsbclust', nclust, start, data)
}

#' @rdname LossMat
#' @title C++ Function for Interaction Loss Function
#' @name LossMat
#' @description This function calculates the loss function for the interaction clustering
#' for all data slices and clusters means. The inputs are numeric matrices.
#' @param x The data matrix, with the N slices strung out as vectors in the columns.
#' @param y The matrix of cluster means, with each mean represented by a row.
#' @return A numeric matrix with \code{nclust} rows and \code{N} columns.
NULL

LossMat <- function(x, y) {
    .Call('lsbclust_LossMat', PACKAGE = 'lsbclust', x, y)
}

