% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmAll.R
\name{rmAll}
\alias{rmAll}
\title{Remove all objects}
\usage{
rmAll(ask = TRUE)
}
\arguments{
\item{ask}{Logical value indicating whether to ask user to confirm deletions. Default is \code{TRUE}}
}
\value{
Invisibly returns 0 if no deletions are made, 1 if at least one deletion is made.
}
\description{
Removes all objects from the workspace
}
\details{
The \code{rmAll} function provides a simple way of deleting all
objects from the workspace. It is almost equivalent to the usual
\code{rm(list = objects())} command. The only difference that it requires
the user to confirm the deletions first if \code{ask = TRUE}, after
displaying a list of the current objects in the worspace. This can
occasionally be useful for teaching purposes.
}
\seealso{
\code{\link{rm}}
}
