% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/angle.R
\name{Angle}
\alias{Angle}
\title{Standardized last principal angle}
\usage{
Angle(A, B)
}
\arguments{
\item{A}{numerical matrix of size \emph{p} by \emph{k}}

\item{B}{numerical matrix of size \emph{q} by \emph{l}}
}
\value{
Standardised last principal angle between A and B.
}
\description{
Standardised last principal angle between the subspaces generated by the columns of A and B.
}
\references{
Bjorck, A. and Golub, G. H. (1973), ``Numerical Methods for Computing Angles Between Linear Subspaces,'' \emph{Mathematics of Computation}, 27, 579--594.

Hubert, M., Rousseeuw, P. J., and Vanden Branden, K. (2005), ``ROBPCA: A New Approach to Robust Principal Component Analysis,'' \emph{Technometrics}, 47, 64--79.

Hubert, M., Reynkens, T., Schmitt, E. and Verdonck, T. (2016), ``Sparse PCA for High-Dimensional Data With Outliers,'' \emph{Technometrics}, 58, 424--434.
}
\author{
Tom Reynkens
}
