% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort.R
\name{sort.lvec}
\alias{sort.lvec}
\title{Sort a lvec}
\usage{
\method{sort}{lvec}(x, decreasing = FALSE, clone = TRUE, ...)
}
\arguments{
\item{x}{lvec to sort}

\item{decreasing}{unused (a value unequal to \code{FALSE} will generate an error).}

\item{clone}{clone x before sorting}

\item{...}{unused.}
}
\value{
Sorts \code{x} and returns a sorted copy of \code{x}. When \code{clone} is 
\code{FALSE} the input vector is modified.
}
\description{
Sort a lvec
}
\examples{
x <- as_lvec(rnorm(10))
sort(x)

# Effect of clone
a <- as_lvec(rnorm(10))
b <- sort(a, clone = FALSE)
print(a)

}
