% Generated by roxygen2 (4.0.2): do not edit by hand
\name{recursiveTree}
\alias{recursiveTree}
\title{European Call Option Price (Recursive)}
\usage{
recursiveTree(S, K, sigma, r, delta, h, T = 1)
}
\arguments{
\item{S}{The Stock Price}

\item{K}{The Strike Price}

\item{sigma}{The volatility}

\item{r}{The risk-free continuously compounded interest rate}

\item{delta}{The annualized dividend rate}

\item{h}{the number of periods betwen 0 and T, where each period is of length 1/h}

\item{T}{the expiration time}
}
\description{
Determines the price of a European Call Option by using a recursive relationship in the binomial tree
}
\details{
Uses formulas for u and d presented by Cox in his forward tree model. Note that the option price converges to the Black-Scholes option price
}
\examples{
recursiveTree(S=41,K=40,sigma=0.3,r=0.08,delta=0,h=5,T=1)
}

