% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int_to_prob.R
\name{int_to_prob}
\alias{int_to_prob}
\title{Transforming a set of Multinomial logit regression intercepts to probabilities}
\usage{
int_to_prob(int_matrix)
}
\arguments{
\item{int_matrix}{A matrix with (number of states OR categories - 1) columns
and number of rows to be determined by the user. For obtaining the set of
probabilities of the complete transition probability matrix gamma or
categorical emission distribution matrix, the number of rows equals the
number of states \code{m}. The first state / category is assumed to be the
reference category, no intercept is to be specified for this first
category.}
}
\value{
\code{int_to_prob} returns a matrix containing probabilities with
  each row summing to one, with the number of columns equal to the number of
  states / categories and the number of rows equal to the number rows
  specified in the input matrix.
}
\description{
\code{int_to_prob} transforms a set of Multinomial logit regression
intercepts to the corresponding state transition or categorical emission
observation probabilities. Note that the first state or category is assumed
to be the reference category, hence no intercept is to specified for the
first state or category.
}
\details{
Designed to ease the specification of informative hyper-prior values for the
mean intercepts of the transition probability matrix gamma and categorical
emission distribution(s) of the multilevel hidden Markov model through the
functions \code{\link{prior_gamma}} and \code{\link{prior_emiss_cat}}. No
check is performed on correct specifications of the dimensions.
}
\examples{

# example for transition probability matrix gamma with 3 states
m <- 3
gamma_int <- matrix(c(-1, -1,
                       3,  0,
                       0,  2), ncol = m-1, nrow = m, byrow = TRUE)
gamma_prob <- int_to_prob(gamma_int)
gamma_prob

}
\seealso{
\code{\link{prob_to_int}} for transforming a set of probabilities to
  a set of Multinomial logit regression intercepts, \code{\link{prior_gamma}}
  and \code{\link{prior_emiss_cat}} for specifying informative hyper-priors
  for the the multilevel hidden Markov model and \code{\link{mHMM}} to fit a
  multilevel hidden Markov model.
}
