% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum.r
\docType{methods}
\name{sumprod}
\alias{sumprod}
\alias{sum,madness-method}
\alias{sum}
\alias{prod,madness-method}
\alias{prod}
\title{Sum and Product.}
\usage{
\S4method{sum}{madness}(x, ..., na.rm = FALSE)

\S4method{prod}{madness}(x, ..., na.rm = FALSE)
}
\arguments{
\item{x}{a numeric or \code{madness} object.}

\item{...}{ignored here.}

\item{na.rm}{logical. Should missing values (including \sQuote{NaN}) be
removed?}
}
\value{
a \code{madness} object representing a scalar value.
}
\description{
Compute sum or product of \code{madness} objects.
}
\examples{
xv <- matrix(rnorm(5*5),ncol=5)
xmad <- madness(xv)
prod(xv)
sum(xv)
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
