% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcOutput.R
\name{calcOutput}
\alias{calcOutput}
\title{calcOutput}
\usage{
calcOutput(
  type,
  aggregate = TRUE,
  file = NULL,
  years = NULL,
  round = NULL,
  supplementary = FALSE,
  append = FALSE,
  na_warning = TRUE,
  try = FALSE,
  ...
)
}
\arguments{
\item{type}{output type, e.g. "TauTotal". A list of all available source
types can be retrieved with function \code{\link{getCalculations}}.}

\item{aggregate}{Boolean indicating whether output data aggregation should be performed or
not, "GLO" (or "glo") for aggregation to one global region,
"REG+GLO" (or "regglo") for a combination of regional and global data.}

\item{file}{A file name. If given the output is written to that file in the
outputfolder as specified in the config.}

\item{years}{A vector of years that should be returned. If set to NULL all
available years are returned.}

\item{round}{A rounding factor. If set to NULL no rounding will occur.}

\item{supplementary}{boolean deciding whether supplementary information such as weight should be
returned or not. If set to TRUE a list of elements will be returned!}

\item{append}{boolean deciding whether the output data should be appended in the existing file.
Works only when a file name is given in the function call.}

\item{na_warning}{boolean deciding whether NAs in the data set should create a warning or not}

\item{try}{if set to TRUE the calculation will only be tried and the script will continue even if
the underlying calculation failed. If set to TRUE calculation will stop with an error in such a
case. This setting will be overwritten by the global setting debug=TRUE, in which try will be
always interpreted as TRUE.}

\item{...}{Additional settings directly forwarded to the corresponding
calculation function}
}
\value{
magpie object with the requested output data either on country or on
regional level depending on the choice of argument "aggregate" or a list of information
if supplementary is set to TRUE.
}
\description{
Calculate a specific output for which a calculation function exists. The function is a
wrapper for specific functions designed for the different possible output types.
}
\note{
The underlying calc-functions are required to provide a list of information back to
\code{calcOutput}. Following list entries should be provided:
\itemize{
\item \bold{x} - the data itself as magclass object
\item \bold{weight} - a weight for the spatial aggregation
\item \bold{unit} - unit of the provided data
\item \bold{description} - a short description of the data
\item \bold{note} (optional) - additional notes related to the data
\item \bold{class} (optional | default = "magpie") - Class of the returned object. If set to
something other than "magpie" most functionality, such as aggregation or unit tests will not
be available and is switched off!
\item \bold{isocountries} (optional | default = TRUE (mostly) or FALSE (if global)) - a boolean
indicating whether data is in iso countries or not (the latter will deactivate several
features such as aggregation)
\item \bold{mixed_aggregation} (optional | default = FALSE) - boolean which allows for mixed
aggregation (weighted mean mixed with summations). If set to TRUE weight columns
filled with NA will lead to summation, otherwise they will trigger an error.
\item \bold{min} (optional) - Minimum value which can appear in the data. If provided calcOutput
will check whether there are any values below the given threshold and warn in this case
\item \bold{max} (optional) - Maximum value which can appear in the data. If provided calcOutput
will check whether there are any values above the given threshold and warn in this case
\item \bold{structure.spatial} (optional) - regular expression describing the name structure of all
names in the spatial dimension (e.g. "^[A-Z]\{3\}$"). Names will be checked against this regular expression and
disagreements will be reported via a warning.
\item \bold{structure.temporal} (optional) - regular expression describing the name structure of all
names in the temporal dimension (e.g. "^y[0-9]\{4\}$"). Names will be checked against this regular expression and
disagreements will be reported via a warning.
\item \bold{structure.data} (optional) - regular expression describing the name structure of all
names in the data dimension (e.g. "^[a-z]*\\\\.[a-z]*$"). Names will be checked against this regular expression and
disagreements will be reported via a warning.
\item \bold{aggregationFunction} (optional | default = toolAggregate) - Function to be used to
aggregate data from country to regions. The function must have the argument \code{x} for
the data itself and \code{rel} for the relation mapping between countries and regions and
must return the data as magpie object in the spatial resolution as defined in rel.
\item \bold{aggregationArguments} (optional) - List of additional, named arguments to be supplied
to the aggregation function. In addition to the arguments set here, the function will be
supplied with the arguments \code{x}, \code{rel} and if provided/deviating from the default
also \code{weight} and \code{mixed_aggregation}.
}
}
\examples{
\dontrun{

a <- calcOutput(type = "TauTotal")
}

}
\seealso{
\code{\link{setConfig}}, \code{\link{calcTauTotal}},
}
\author{
Jan Philipp Dietrich
}
