% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-dictionaries_functions.R
\name{as_data_dict_mlstr}
\alias{as_data_dict_mlstr}
\title{Validate and coerce an object to an Opal data dictionary format}
\usage{
as_data_dict_mlstr(object, as_data_dict = FALSE)
}
\arguments{
\item{object}{A potential valid data dictionary to be coerced.}

\item{as_data_dict}{Whether the output data dictionary has a simple
data dictionary structure or not (meaning has a Maelstrom data dictionary
structure, compatible with Maelstrom Research ecosystem, including Opal).
FALSE by default.}
}
\value{
A list of tibble(s) identifying a data dictionary.
}
\description{
Validates the input object as a valid data dictionary compliant with formats
used in Maelstrom Research ecosystem, including Opal, and returns it with
the appropriate madshapR::class attribute. This function mainly helps
validate input within other functions of the package but could be used to
check if an object is valid for use in a function.
}
\details{
A data dictionary contains metadata about variables and can be associated
with a dataset. It must be a list of data frame-like objects with elements
named 'Variables' (required) and 'Categories' (if any). To be usable in any
function, the 'Variables' element must contain at least the 'name' column,
and the 'Categories' element must contain at least the 'variable' and 'name'
columns. To be considered as a minimum workable data dictionary, in
'Variables' the 'name' column must also have unique and non-null entries,
and in 'Categories' the combination of 'variable' and 'name' columns must
also be unique'.
}
\examples{
{

# use DEMO_files provided by the package

data_dict <- DEMO_files$dd_MELBOURNE_1_format_maelstrom
as_data_dict_mlstr(DEMO_files$dd_MELBOURNE_1_format_maelstrom)

}

}
\seealso{
For a better assessment, please use \code{\link[=data_dict_evaluate]{data_dict_evaluate()}}.
}
